/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.options.JavaAgents;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import java.util.Collections;

public class JavaAgent
implements JvmOption,
Option.Collectable {
    private ClassPath path;
    private String parameters;

    private JavaAgent(String path) {
        this(path, "");
    }

    private JavaAgent(String path, String parameters) {
        this.path = new ClassPath(path);
        String string = this.parameters = parameters == null ? "" : parameters.trim();
        if (this.path.size() != 1) {
            throw new IllegalArgumentException("JavaAgent path [" + path + "] may only contain a single path entry, to a Java Archive");
        }
    }

    public static JavaAgent using(String path) {
        return new JavaAgent(path);
    }

    public static JavaAgent using(String path, String parameters) {
        return new JavaAgent(path, parameters);
    }

    public Class<? extends Option.Collector> getCollectorClass() {
        return JavaAgents.class;
    }

    @Override
    public Iterable<String> resolve(OptionsByType optionsByType) {
        String resolvedParameters;
        if (this.parameters.isEmpty()) {
            resolvedParameters = "";
        } else {
            ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
            resolvedParameters = "=" + (String)evaluator.evaluate(this.parameters, String.class);
        }
        String agent = "-javaagent:" + this.path.toString(optionsByType) + resolvedParameters;
        return Collections.singletonList(agent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaAgent)) {
            return false;
        }
        JavaAgent javaAgent = (JavaAgent)o;
        if (this.path != null ? !this.path.equals(javaAgent.path) : javaAgent.path != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(javaAgent.parameters) : javaAgent.parameters == null;
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

