/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Argument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class Arguments
implements Option.Collector<Argument, Arguments> {
    private static final Arguments EMPTY = new Arguments();
    private final List<Argument> arguments = new ArrayList<Argument>();

    private Arguments() {
    }

    public List<String> resolve(Platform platform, OptionsByType optionsByType) {
        if (optionsByType == null) {
            optionsByType = OptionsByType.empty();
        }
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        ArrayList<String> argList = new ArrayList<String>();
        for (Argument argument : this.arguments) {
            String name = argument.getName();
            char separator = argument.getSeparator();
            List<String> values = argument.resolve(platform, evaluator, optionsByType);
            if (name != null && !name.isEmpty()) {
                if (values == null || values.isEmpty()) continue;
                if (separator == ' ') {
                    values.stream().filter(arg -> arg != null && !arg.isEmpty()).forEach(arg -> {
                        argList.add(name);
                        argList.add((String)arg);
                    });
                    continue;
                }
                values.stream().filter(arg -> arg != null && !arg.isEmpty()).forEach(arg -> argList.add(name + separator + arg));
                continue;
            }
            if (values == null || values.isEmpty()) continue;
            values.stream().filter(s -> s != null && !s.isEmpty()).forEach(argList::add);
        }
        return argList;
    }

    public Arguments with(Object ... arguments) {
        return this.with(Arrays.asList(arguments));
    }

    public Arguments with(List<?> arguments) {
        Arguments newArguments = new Arguments();
        newArguments.arguments.addAll(this.arguments);
        for (Object argument : arguments) {
            if (argument instanceof Argument) {
                newArguments.arguments.add((Argument)argument);
                continue;
            }
            newArguments.arguments.add(new Argument(argument, new Option[0]));
        }
        return newArguments;
    }

    public Arguments with(Argument ... arguments) {
        return this.with(Arrays.asList(arguments));
    }

    public Arguments with(Argument argument) {
        Arguments newArguments = new Arguments();
        newArguments.arguments.addAll(this.arguments);
        newArguments.arguments.add(argument);
        return newArguments;
    }

    public Arguments with(Arguments other) {
        Arguments newArguments = new Arguments();
        newArguments.arguments.addAll(this.arguments);
        newArguments.arguments.addAll(other.arguments);
        return newArguments;
    }

    public Arguments without(Object argument) {
        Argument arg = argument instanceof Argument ? (Argument)argument : new Argument(argument, new Option[0]);
        return this.without(arg);
    }

    public Arguments without(Argument ... arguments) {
        Arguments newArguments = new Arguments();
        newArguments.arguments.addAll(this.arguments);
        for (Argument argument : arguments) {
            newArguments.arguments.remove(argument);
        }
        return newArguments;
    }

    public Arguments without(Argument argument) {
        Arguments newArguments = new Arguments();
        newArguments.arguments.addAll(this.arguments);
        newArguments.arguments.remove(argument);
        return newArguments;
    }

    public Arguments withoutNamed(String name) {
        Arguments newArguments = new Arguments();
        for (Argument argument : this.arguments) {
            String argName = argument.getName();
            if (this.safeEquals(argName, name)) continue;
            newArguments.arguments.add(argument);
        }
        return newArguments;
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(Argument.class)) {
            return this.arguments;
        }
        return Collections.EMPTY_LIST;
    }

    public Iterator<Argument> iterator() {
        return Collections.unmodifiableCollection(this.arguments).iterator();
    }

    public Arguments replace(String name, Object value) {
        Argument argument = Argument.of(name, value, new Option[0]);
        return this.replace(argument);
    }

    public Arguments replace(Argument argument) {
        String name = argument.getName();
        Arguments newArguments = new Arguments();
        boolean replaced = false;
        for (Argument arg : this.arguments) {
            if (!replaced && this.safeEquals(arg.getName(), name)) {
                newArguments.arguments.add(argument);
                replaced = true;
                continue;
            }
            newArguments.arguments.add(arg);
        }
        if (!replaced) {
            newArguments.arguments.add(argument);
        }
        return newArguments;
    }

    private boolean safeEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1 != null && s1.equals(s2);
    }

    public Stream<Argument> stream() {
        return this.arguments.stream();
    }

    public static Arguments of(Object ... arguments) {
        return Arguments.of(Arrays.asList(arguments));
    }

    public static Arguments of(Argument ... arguments) {
        return EMPTY.with(arguments);
    }

    public static Arguments of(List<?> arguments) {
        return EMPTY.with(arguments);
    }

    @OptionsByType.Default
    public static Arguments empty() {
        return EMPTY;
    }
}

