/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import java.io.File;
import java.nio.file.Path;

public class TemporaryDirectory
implements Option {
    private Path path;

    private TemporaryDirectory(Path location) {
        this.path = location;
    }

    private TemporaryDirectory(String location) {
        this.path = new File(location).toPath();
    }

    public Path get() {
        return this.path;
    }

    public String toString() {
        return "TemporaryDirectory{" + this.path + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TemporaryDirectory)) {
            return false;
        }
        TemporaryDirectory that = (TemporaryDirectory)other;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static TemporaryDirectory at(String location) {
        return new TemporaryDirectory(location);
    }

    public static TemporaryDirectory at(Path location) {
        return new TemporaryDirectory(location);
    }
}

