/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.io.NetworkHelper;
import com.oracle.bedrock.runtime.AbstractPlatform;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.SimpleApplicationLauncher;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteChannelListener;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannelClient;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannelServer;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.LocalJavaApplicationLauncher;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class LocalPlatform
extends AbstractPlatform {
    private static LocalPlatform INSTANCE = new LocalPlatform();
    private OperatingSystem operatingSystem = OperatingSystem.local();
    private AvailablePortIterator availablePortIterator;
    private InetAddress address;

    private LocalPlatform() {
        super("Local", new Option[0]);
        String addressSystemProperty = System.getProperty("bedrock.runtime.address");
        if (addressSystemProperty == null) {
            this.address = NetworkHelper.getFeasibleLocalHost();
        } else {
            try {
                this.address = InetAddress.getByName(addressSystemProperty);
            }
            catch (UnknownHostException e) {
                this.address = NetworkHelper.getFeasibleLocalHost();
            }
        }
        List bindableAddresses = NetworkHelper.getInetAddresses((Predicate)NetworkHelper.BINDABLE_ADDRESS);
        this.availablePortIterator = new AvailablePortIterator(30000, 65535, bindableAddresses);
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public AvailablePortIterator getAvailablePorts() {
        return this.availablePortIterator;
    }

    public static LocalPlatform get() {
        return INSTANCE;
    }

    @Override
    protected <A extends Application, B extends ApplicationLauncher<A>> B getApplicationLauncher(MetaClass<A> metaClass, OptionsByType optionsByType) throws UnsupportedOperationException {
        Class<A> applicationClass = metaClass.getImplementationClass(this, optionsByType);
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new LocalJavaApplicationLauncher();
        }
        return (B)new SimpleApplicationLauncher();
    }

    public static void main(String[] arguments) throws UnknownHostException, SocketException {
        LocalPlatform platform = LocalPlatform.get();
        System.out.println("----------------------------------");
        System.out.println("Bedrock: LocalPlatform Diagnostics");
        System.out.println("----------------------------------");
        System.out.println("Platform Name       : " + platform.getName());
        System.out.println("Operating System    : " + platform.getOperatingSystem());
        System.out.println("Address             : " + platform.getAddress());
        System.out.println("Available Ports     : " + platform.getAvailablePorts());
        System.out.println("Options             : " + platform.getOptions());
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("Bedrock: Network Diagnostics");
        System.out.println("----------------------------");
        System.out.println("LocalHost Address   : " + InetAddress.getLocalHost());
        System.out.println("Loopback Address    : " + InetAddress.getLoopbackAddress());
        System.out.println("Prefer IPv4         : " + System.getProperty("java.net.preferIPv4Stack", "(undefined)"));
        System.out.println("Prefer IPv6         : " + System.getProperty("java.net.preferIPv6Stack", "(undefined)"));
        System.out.println();
        System.out.println("Network Interfaces:");
        System.out.println("-------------------");
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            System.out.println("Display Name        : " + networkInterface.getDisplayName() + " (" + networkInterface.getName() + ") #" + networkInterface.getIndex());
            System.out.println("Is Active?          : " + networkInterface.isUp());
            System.out.println("Is Loopback?        : " + networkInterface.isLoopback());
            System.out.println("Is Virtual?         : " + networkInterface.isVirtual());
            System.out.println("Is Point-To-Point?  : " + networkInterface.isPointToPoint());
            System.out.println("Supports Multicast? : " + networkInterface.supportsMulticast());
            System.out.print("Hardware Address    : ");
            byte[] hardwareAddress = networkInterface.getHardwareAddress();
            if (hardwareAddress == null) {
                System.out.println("(undefined)");
            } else {
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    System.out.print((i > 0 ? ":" : "") + Integer.toString((hardwareAddress[i] & 0xFF) + 256, 16).substring(1));
                }
                System.out.println();
            }
            System.out.print("InetAddresses       : ");
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                System.out.print(inetAddress + (inetAddresses.hasMoreElements() ? ", " : ""));
            }
            System.out.println();
            System.out.println();
        }
        try (SocketBasedRemoteChannelServer server = new SocketBasedRemoteChannelServer(platform.getName());){
            System.out.println("Network Connectivity Tests:");
            System.out.println("---------------------------");
            server.addListener(new RemoteChannelListener(){

                @Override
                public void onOpened(RemoteChannel channel) {
                    if (channel instanceof SocketBasedRemoteChannel) {
                        System.out.println("[Server]: Connection Opened");
                    }
                }

                @Override
                public void onClosed(RemoteChannel channel) {
                    if (channel instanceof SocketBasedRemoteChannel) {
                        System.out.println("[Server]: Connection Closed\n");
                    }
                }
            });
            InetAddress serverAddress = server.open();
            System.out.println("Established Server Socket Listening at : " + serverAddress + ":" + server.getPort());
            System.out.println();
            LocalPlatform.connectWith(InetAddress.getLoopbackAddress(), server.getPort(), "InetAddress.getLoopbackAddress()");
            LocalPlatform.connectWith(InetAddress.getLocalHost(), server.getPort(), "InetAddress.getLocalHost()");
            LocalPlatform.connectWith(platform.getAddress(), server.getPort(), "LocalPlatform.getAddress()");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void connectWith(InetAddress inetAddress, int port, String description) {
        try (SocketBasedRemoteChannelClient client = new SocketBasedRemoteChannelClient(inetAddress, port);){
            System.out.println("Connection Validation For : " + description);
            System.out.println("---------------------------");
            System.out.println("[Client]: Establishing Client Socket on : " + inetAddress + ":" + port);
            client.open();
            System.out.println("[Client]: Sending Client Request to Server...");
            CompletableFuture<String> future = client.submit(new PingPong(description), new Option[0]);
            System.out.println("[Client]: Waiting for Server Response...");
            String value = future.get(15L, TimeUnit.SECONDS);
            if (description.equals(value)) {
                System.out.println("[Client]: Server successfully executed Client Request");
            } else {
                System.out.println("[Client]: Server failed to execute Client Request.  Returned [" + value + "] instead of [" + description + "]");
            }
            System.out.println("[Client]: Closing Client Socket on : " + inetAddress + ":" + port);
            System.out.println();
        }
        catch (ExecutionException e) {
            System.out.println("[Client]: Server failed to execute the Client Request:");
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            System.out.println("[Client]: Server failed to execute the Client Request in the required timeout");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.out.println("[Client]: Client was interrupted waiting for the Server Response");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("[Client]: Failed to connect to: " + description);
            e.printStackTrace();
        }
    }

    public static class PingPong
    implements RemoteCallable<String> {
        private String value;

        public PingPong(String value) {
            this.value = value;
        }

        @Override
        public String call() throws Exception {
            System.out.println("[Server]: Executing Client Request <" + this.value + ">");
            return this.value;
        }
    }
}

