/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Arguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Argument
implements Option.Collectable {
    private final String name;
    private final char separator;
    private final Object value;
    private final Option[] options;

    public Argument(Object value, Option ... options) {
        this(null, ' ', value, options);
    }

    public Argument(String name, Object value, Option ... options) {
        this(name, ' ', value, options);
    }

    public Argument(String name, char separator, Object value, Option ... options) {
        this.name = name;
        this.separator = separator;
        this.value = value;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public Argument withSeparator(char separator) {
        if (separator == this.separator) {
            return this;
        }
        return new Argument(this.name, separator, this.value, new Option[0]);
    }

    public char getSeparator() {
        return this.separator;
    }

    public Object getValue() {
        return this.value;
    }

    public OptionsByType getOptions() {
        return OptionsByType.of((Option[])this.options);
    }

    public List<String> resolve(Platform platform, ExpressionEvaluator evaluator, OptionsByType optionsByType) {
        List<Object> argList;
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.value instanceof Multiple) {
            argList = new ArrayList();
            for (Object argValue : ((Multiple)this.value).getValues()) {
                Object result = this.resolveValue(argValue, platform, evaluator, optionsByType);
                if (result == null) continue;
                argList.add(String.valueOf(result));
            }
        } else {
            Object result = this.resolveValue(this.value, platform, evaluator, optionsByType);
            argList = result != null ? Collections.singletonList(String.valueOf(result)) : Collections.emptyList();
        }
        OptionsByType argOptions = this.getOptions();
        Iterable handlers = argOptions.getInstancesOf(ResolveHandler.class);
        for (ResolveHandler handler : handlers) {
            try {
                handler.onResolve(this.name, Collections.unmodifiableList(argList), optionsByType);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return argList;
    }

    private Object resolveValue(Object argValue, Platform platform, ExpressionEvaluator evaluator, OptionsByType optionsByType) {
        if (argValue instanceof ContextSensitiveArgument) {
            ContextSensitiveArgument contextSensitiveValue = (ContextSensitiveArgument)argValue;
            argValue = contextSensitiveValue.resolve(platform, optionsByType);
        }
        if (argValue instanceof Iterator) {
            Iterator iterator = (Iterator)argValue;
            if (iterator.hasNext()) {
                argValue = iterator.next().toString();
            } else {
                throw new IndexOutOfBoundsException(String.format("No more values available for the argument [%s]", this.value));
            }
        }
        if (argValue == null) {
            return null;
        }
        String expression = argValue.toString().trim();
        Object result = evaluator.evaluate(expression, Object.class);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument argument = (Argument)o;
        if (this.separator != argument.separator) {
            return false;
        }
        if (this.name != null ? !this.name.equals(argument.name) : argument.name != null) {
            return false;
        }
        return this.value != null ? this.value.equals(argument.value) : argument.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.separator;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name != null ? this.name + this.separator + this.value : String.valueOf(this.value);
    }

    public Class<? extends Option.Collector> getCollectorClass() {
        return Arguments.class;
    }

    public static Argument of(Object arg, Option ... options) {
        return new Argument(arg, options);
    }

    public static Argument of(String name, Object arg, Option ... options) {
        return new Argument(name, arg, options);
    }

    public static Argument of(String name, char separator, Object arg, Option ... options) {
        return new Argument(name, separator, arg, options);
    }

    public static class Multiple {
        private final List<?> values;

        public Multiple(Collection<?> values) {
            this.values = values == null ? Collections.emptyList() : new ArrayList(values);
        }

        public Multiple(Object ... values) {
            this.values = Arrays.asList(values);
        }

        public List<?> getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Multiple multiple = (Multiple)o;
            return this.values.equals(multiple.values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public String toString() {
            return String.valueOf(this.values);
        }
    }

    @FunctionalInterface
    public static interface ResolveHandler {
        public void onResolve(String var1, List<String> var2, OptionsByType var3);
    }

    public static interface ContextSensitiveArgument {
        public Object resolve(Platform var1, OptionsByType var2);
    }
}

