/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.console.InputRedirector;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InputFromIntputStreamRedirector
extends InputRedirector {
    public static final int DEFAULT_PIPE_SIZE = 1024;
    private final InputStream inputStream;
    private final int bufferSize;
    private CountDownLatch running = new CountDownLatch(1);

    public InputFromIntputStreamRedirector(InputStream inputStream) {
        this(inputStream, 1024);
    }

    public InputFromIntputStreamRedirector(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.bufferSize = bufferSize <= 0 ? 1024 : bufferSize;
    }

    public boolean isRunning() {
        return this.running.getCount() > 0L;
    }

    public boolean awaitRunning(long timeout, TimeUnit unit) throws InterruptedException {
        return this.running.await(timeout, unit);
    }

    @Override
    public void run() {
        try {
            this.running.countDown();
            OutputStream outputStream = this.getOutputStream();
            byte[] buffer = new byte[this.bufferSize];
            int len = this.inputStream.read(buffer);
            while (len >= 0) {
                if (len > 0) {
                    outputStream.write(buffer, 0, len);
                    outputStream.flush();
                }
                len = this.inputStream.read(buffer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

