/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.extensible.Extensible;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.SimpleApplication;
import java.io.Closeable;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public interface Application
extends Extensible,
Closeable {
    public String getName();

    public Platform getPlatform();

    @Override
    public void close();

    public void close(Option ... var1);

    public boolean isOperational();

    public int waitFor(Option ... var1);

    public int exitValue();

    public long getId();

    public Timeout getDefaultTimeout();

    public OptionsByType getOptions();

    public static <A extends Application> Predicate<A> withName(String name) {
        String regex = Pattern.quote(name);
        final Pattern pattern = Pattern.compile(regex);
        return new Predicate<A>(){

            @Override
            public boolean test(A a) {
                return pattern.matcher(a.getName()).matches();
            }
        };
    }

    public static <A extends Application> Predicate<A> withNameMatching(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return a -> pattern.matcher(a.getName()).matches();
    }

    public static <A extends Application> Predicate<A> withNamePrefix(String name) {
        String regex = Pattern.quote(name);
        Pattern pattern = Pattern.compile(regex);
        return a -> pattern.matcher(a.getName()).lookingAt();
    }

    public static <A extends Application> Predicate<A> withNameContaining(String name) {
        String regex = Pattern.quote(name);
        Pattern pattern = Pattern.compile(regex);
        return a -> pattern.matcher(a.getName()).find();
    }

    public static class MetaClass
    implements com.oracle.bedrock.runtime.MetaClass<Application> {
        @OptionsByType.Default
        public MetaClass() {
        }

        @Override
        public Class<? extends Application> getImplementationClass(Platform platform, OptionsByType optionsByType) {
            return SimpleApplication.class;
        }

        @Override
        public void onLaunching(Platform platform, OptionsByType optionsByType) {
        }

        @Override
        public void onLaunch(Platform platform, OptionsByType optionsByType) {
        }

        @Override
        public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
        }
    }
}

