/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.extensible.AbstractExtensible;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;

@Internal
public abstract class AbstractPlatform
extends AbstractExtensible
implements Platform {
    private String name;
    private OptionsByType optionsByType;

    public AbstractPlatform(String name, Option ... options) {
        this.name = name;
        this.optionsByType = OptionsByType.of((Option[])options);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    @Override
    public <A extends Application> A launch(MetaClass<A> metaClass, Option ... options) {
        OptionsByType launchOptions = OptionsByType.of((Option[])this.getOptions().asArray());
        launchOptions.addAll(options);
        Object launcher = this.getApplicationLauncher(metaClass, launchOptions);
        if (launcher == null) {
            throw new IllegalArgumentException("Can't determine ApplicationLauncher for " + metaClass + " using " + launchOptions);
        }
        return launcher.launch(this, metaClass, launchOptions);
    }

    protected abstract <A extends Application, B extends ApplicationLauncher<A>> B getApplicationLauncher(MetaClass<A> var1, OptionsByType var2) throws UnsupportedOperationException;
}

