/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Profile;

public class Profiles {
    public static OptionsByType getProfiles() {
        String ORACLE_TOOLS_PROFILE = "bedrock.profile.";
        OptionsByType profiles = OptionsByType.empty();
        for (String name : System.getProperties().stringPropertyNames()) {
            if (!name.startsWith("bedrock.profile.")) continue;
            String profileName = name.substring("bedrock.profile.".length()).trim().toLowerCase();
            String profileValue = System.getProperty(name);
            if (profileName.indexOf(".") >= 0) continue;
            Object profileClassName = System.getProperty(name + ".classname");
            if (profileClassName == null) {
                profileClassName = "com.oracle.bedrock." + profileName + "." + profileName.substring(0, 1).toUpperCase() + profileName.substring(1) + "Profile";
            }
            try {
                Class<?> profileClass = Class.forName((String)profileClassName);
                if (!Option.class.isAssignableFrom(profileClass)) continue;
                Profile profile = (Profile)profiles.get(profileClass, new Object[]{profileValue});
            }
            catch (Exception exception) {}
        }
        return profiles;
    }
}

