/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.java.JavaApplicationRunner;
import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.java.container.ContainerScope;
import java.io.Closeable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CompletableFuture;

public interface RemoteChannel
extends Closeable {
    public <T> CompletableFuture<T> submit(RemoteCallable<T> var1, Option ... var2) throws IllegalStateException;

    public CompletableFuture<Void> submit(RemoteRunnable var1, Option ... var2) throws IllegalStateException;

    public void addListener(RemoteEventListener var1, Option ... var2);

    public void removeListener(RemoteEventListener var1, Option ... var2);

    public CompletableFuture<Void> raise(RemoteEvent var1, Option ... var2);

    public static RemoteChannel get() {
        ContainerScope containerScope = Container.getContainerScope();
        if (containerScope == null) {
            return JavaApplicationRunner.channel;
        }
        return (RemoteChannel)containerScope.getRemoteChannel();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Inject {
    }

    public static enum AcknowledgeWhen implements Option
    {
        SENT,
        PROCESSED;

    }
}

