/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Profile;
import java.util.ServiceLoader;

public class Profiles {
    public static final String ORACLE_TOOLS_PROFILE = "bedrock.profile.";

    public static OptionsByType getProfiles() {
        OptionsByType profiles = OptionsByType.empty();
        for (String name : System.getProperties().stringPropertyNames()) {
            if (name.startsWith(ORACLE_TOOLS_PROFILE)) {
                String profileName = name.substring(ORACLE_TOOLS_PROFILE.length()).trim().toLowerCase();
                String profileValue = System.getProperty(name);
                if (!profileName.contains(".")) {
                    Object profileClassName = System.getProperty(name + ".classname");
                    if (profileClassName == null) {
                        profileClassName = "com.oracle.bedrock." + profileName + "." + profileName.substring(0, 1).toUpperCase() + profileName.substring(1) + "Profile";
                    }
                    try {
                        Class<?> profileClass = Class.forName((String)profileClassName);
                        if (Option.class.isAssignableFrom(profileClass)) {
                            Profile profile = (Profile)profiles.get(profileClass, new Object[]{profileValue});
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ServiceLoader<Profile> loader = ServiceLoader.load(Profile.class);
            for (Profile profile : loader) {
                if (!(profile instanceof Option)) continue;
                profiles.add((Option)profile);
            }
        }
        return profiles;
    }
}

