/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;

public class ClassPathModifier
implements Option {
    private boolean useQuotes = true;

    public ClassPathModifier(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }

    public String modify(String classPath) {
        return classPath;
    }

    public String applyQuotes(String classPath) {
        if (this.useQuotes) {
            StringBuilder builder = new StringBuilder();
            if (!classPath.startsWith("\"")) {
                builder.append('\"');
            }
            builder.append(classPath);
            if (!classPath.endsWith("\"")) {
                builder.append('\"');
            }
            return builder.toString();
        }
        return classPath;
    }

    @OptionsByType.Default
    public static ClassPathModifier none() {
        return new ClassPathModifier(true);
    }

    public static ClassPathModifier forCygwin() {
        return new CygwinModifier(true);
    }

    public static ClassPathModifier forWindows() {
        return new WindowsModifier(false);
    }

    public static ClassPathModifier forWindowsWithQuotes() {
        return new WindowsModifier(true);
    }

    private static class WindowsModifier
    extends ClassPathModifier {
        public WindowsModifier(boolean useQuotes) {
            super(useQuotes);
        }

        @Override
        public String modify(String classPath) {
            return classPath.replaceAll("/", "\\\\");
        }
    }

    private static class CygwinModifier
    extends ClassPathModifier {
        public CygwinModifier(boolean useQuotes) {
            super(useQuotes);
        }

        @Override
        public String modify(String classPath) {
            return String.format("$(cygpath -wp %s)", classPath);
        }
    }
}

