/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.container;

import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.java.container.DelegatingMBeanServer;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

@Internal
public class ContainerMBeanServerBuilder
extends MBeanServerBuilder {
    public static final String JMX_RMI_URL_FORMAT = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    public static final String PROPERTY_JMX_REMOTE_PASSWORD_FILE = "jmx.remote.x.password.file";
    public static final String PROPERTY_JMX_REMOTE_ACCESS_FILE = "jmx.remote.x.access.file";
    public static final String PROPERTY_JMX_REMOTE_RMI_CLIENT_SOCKET_FACTORY = "jmx.remote.rmi.client.socket.factory";
    public static final String PROPERTY_JMX_REMOTE_RMI_SERVER_SOCKET_FACTORY = "jmx.remote.rmi.server.socket.factory";
    public static final String PROPERTY_JMX_MBEAN_SERVER_BUILDER = "javax.management.builder.initial";
    public static final String DEFAULT_JMXREMOTE_PASSWORD_FILE = "/lib/management/jmxremote.password";
    public static final String DEFAULT_JMXREMOTE_ACCESS_FILE = "/lib/management/jmxremote.access";
    public static final String DEFAULT_RMICLIENT_SOCKET_FACTORY = "javax.rmi.ssl.SslRMIClientSocketFactory";
    public static final String DEFAULT_RMISERVER_SOCKET_FACTORY = "javax.rmi.ssl.SslRMIServerSocketFactory";
    private final String m_mBeanServerBuilderClassName = System.getProperties().containsKey("javax.management.builder.initial") ? System.getProperty("javax.management.builder.initial") : MBeanServerBuilder.class.getCanonicalName();
    private final ConnectorFactory m_jmxConnectorFactory;
    private final RmiRegistryFactory m_rmiRegistryFactory;
    private AvailablePortIterator m_availablePortIterator;
    private Map<String, MBeanServer> m_mBeanServers = new HashMap<String, MBeanServer>();
    private Map<MBeanServer, JMXConnectorServer> m_jmxConnectorServers = new HashMap<MBeanServer, JMXConnectorServer>();

    public ContainerMBeanServerBuilder(AvailablePortIterator availablePortIterator) {
        this(new DefaultConnectorFactory(), new DefaultRmiRegistryFactory(), availablePortIterator);
    }

    public ContainerMBeanServerBuilder(ConnectorFactory jmxConnectorFactory, RmiRegistryFactory rmiRegistryFactory, AvailablePortIterator availablePortIterator) {
        this.m_jmxConnectorFactory = jmxConnectorFactory;
        this.m_rmiRegistryFactory = rmiRegistryFactory;
        this.m_availablePortIterator = availablePortIterator;
    }

    public String getPreviousMBeanServerBuilderClassName() {
        return this.m_mBeanServerBuilderClassName;
    }

    public synchronized MBeanServer getMBeanServer(String domain) {
        return this.m_mBeanServers.get(domain);
    }

    public synchronized JMXConnectorServer getJMXConnectorServer(MBeanServer mBeanServer) {
        mBeanServer = mBeanServer instanceof DelegatingMBeanServer ? this.getMBeanServer(((DelegatingMBeanServer)mBeanServer).getDomain()) : mBeanServer;
        return this.m_jmxConnectorServers.get(mBeanServer);
    }

    @Override
    public synchronized MBeanServer newMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate) {
        MBeanServer mBeanServer = this.m_mBeanServers.get(domain);
        if (mBeanServer == null) {
            boolean isRemoteJMXEnabled;
            mBeanServer = super.newMBeanServer(domain, outer, delegate);
            this.m_mBeanServers.put(domain, mBeanServer);
            boolean bl = isRemoteJMXEnabled = System.getProperties().containsKey("com.sun.management.jmxremote") && !"false".equalsIgnoreCase(System.getProperty("com.sun.management.jmxremote"));
            if (isRemoteJMXEnabled) {
                this.createJMXConnectorServer(mBeanServer, System.getProperties());
            }
        }
        return new DelegatingMBeanServer(domain);
    }

    @Override
    public MBeanServerDelegate newMBeanServerDelegate() {
        return super.newMBeanServerDelegate();
    }

    JMXConnectorServer createJMXConnectorServer(MBeanServer mBeanServer, Properties properties) {
        try {
            int port;
            String hostName = properties.containsKey("java.rmi.server.hostname") ? properties.getProperty("java.rmi.server.hostname") : LocalPlatform.get().getAddress().getHostAddress();
            if (properties.containsKey("com.sun.management.jmxremote.port")) {
                port = Integer.parseInt(properties.getProperty("com.sun.management.jmxremote.port"));
            } else {
                port = this.m_availablePortIterator.next();
                properties.setProperty("com.sun.management.jmxremote.port", String.valueOf(port));
            }
            this.m_rmiRegistryFactory.createRegistry(port);
            String remoteJMXConnectionUrl = String.format(JMX_RMI_URL_FORMAT, hostName, port);
            properties.setProperty("com.sun.management.jmxremote.url", remoteJMXConnectionUrl);
            JMXServiceURL url = new JMXServiceURL(remoteJMXConnectionUrl);
            HashMap<String, Object> environment = new HashMap<String, Object>();
            if (Boolean.parseBoolean(properties.getProperty("com.sun.management.jmxremote.authenticate"))) {
                Object accessFileName;
                String javaHome = System.getProperty("java.home");
                Object authFileName = properties.getProperty("com.sun.management.jmxremote.password.file");
                if (authFileName == null) {
                    authFileName = javaHome + DEFAULT_JMXREMOTE_PASSWORD_FILE;
                }
                if (authFileName != null) {
                    environment.put(PROPERTY_JMX_REMOTE_PASSWORD_FILE, authFileName);
                }
                if ((accessFileName = properties.getProperty("com.sun.management.jmxremote.access.file")) == null) {
                    accessFileName = javaHome + DEFAULT_JMXREMOTE_ACCESS_FILE;
                }
                if (accessFileName != null) {
                    environment.put(PROPERTY_JMX_REMOTE_ACCESS_FILE, accessFileName);
                }
            }
            if (Boolean.parseBoolean(properties.getProperty("com.sun.management.jmxremote.ssl"))) {
                try {
                    environment.put(PROPERTY_JMX_REMOTE_RMI_CLIENT_SOCKET_FACTORY, Class.forName(DEFAULT_RMICLIENT_SOCKET_FACTORY).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    environment.put(PROPERTY_JMX_REMOTE_RMI_SERVER_SOCKET_FACTORY, Class.forName(DEFAULT_RMISERVER_SOCKET_FACTORY).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("JMXConnectorServer not started. SSL security requires the Java Dynamic Management Kit or Java 1.5.", e);
                }
            }
            JMXConnectorServer connector = this.m_jmxConnectorFactory.createJMXConnectorServer(url, environment, mBeanServer);
            this.m_jmxConnectorServers.put(mBeanServer, connector);
            connector.start();
            return connector;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start JMXConnectorServer", e);
        }
    }

    public void close() {
        for (JMXConnectorServer connector : this.m_jmxConnectorServers.values()) {
            try {
                connector.stop();
            }
            catch (IOException iOException) {}
        }
        this.m_jmxConnectorServers.clear();
    }

    public static class DefaultRmiRegistryFactory
    implements RmiRegistryFactory {
        @Override
        public void createRegistry(int port) throws RemoteException {
            try {
                LocateRegistry.createRegistry(port);
            }
            catch (ExportException exportException) {
                // empty catch block
            }
        }
    }

    public static class DefaultConnectorFactory
    implements ConnectorFactory {
        @Override
        public JMXConnectorServer createJMXConnectorServer(JMXServiceURL url, Map<String, ?> environment, MBeanServer mBeanServer) throws IOException {
            return JMXConnectorServerFactory.newJMXConnectorServer(url, environment, mBeanServer);
        }

        @Override
        public JMXConnector createJMXConnector(JMXServiceURL url, Map<String, ?> environment) throws IOException {
            return JMXConnectorFactory.newJMXConnector(url, environment);
        }
    }

    public static interface RmiRegistryFactory {
        public void createRegistry(int var1) throws RemoteException;
    }

    public static interface ConnectorFactory {
        public JMXConnectorServer createJMXConnectorServer(JMXServiceURL var1, Map<String, ?> var2, MBeanServer var3) throws IOException;

        public JMXConnector createJMXConnector(JMXServiceURL var1, Map<String, ?> var2) throws IOException;
    }
}

