/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.features;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.deferred.Cached;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.jmx.DeferredJMXConnector;
import com.oracle.bedrock.deferred.jmx.DeferredMBeanAttribute;
import com.oracle.bedrock.deferred.jmx.DeferredMBeanInfo;
import com.oracle.bedrock.deferred.jmx.DeferredMBeanProxy;
import com.oracle.bedrock.extensible.AbstractFeature;
import com.oracle.bedrock.extensible.Extensible;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.profiles.JmxProfile;
import java.io.IOException;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;

public class JmxFeature
extends AbstractFeature {
    public static final String SUN_MANAGEMENT_JMXREMOTE = "com.sun.management.jmxremote";
    public static final String SUN_MANAGEMENT_JMXREMOTE_URL = "com.sun.management.jmxremote.url";
    public static final String SUN_MANAGEMENT_JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    public static final String SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE = "com.sun.management.jmxremote.authenticate";
    public static final String SUN_MANAGEMENT_JMXREMOTE_USER = "com.sun.management.jmxremote.user";
    public static final String SUN_MANAGEMENT_JMXREMOTE_PASSWORD = "com.sun.management.jmxremote.password";
    public static final String SUN_MANAGEMENT_JMXREMOTE_SSL = "com.sun.management.jmxremote.ssl";
    public static final String SUN_MANAGEMENT_JMXREMOTE_PASSWORD_FILE = "com.sun.management.jmxremote.password.file";
    public static final String SUN_MANAGEMENT_JMXREMOTE_ACCESS_FILE = "com.sun.management.jmxremote.access.file";
    protected Cached<JMXConnector> cachedJmxConnector;

    public static boolean isSupportedBy(JavaApplication application) {
        return application.getSystemProperties().containsKey(SUN_MANAGEMENT_JMXREMOTE);
    }

    public JavaApplication getJavaApplication() {
        return (JavaApplication)this.getExtensible().get(JavaApplication.class);
    }

    public Timeout getDefaultTimeout() {
        return this.getJavaApplication().getDefaultTimeout();
    }

    public void onAddingTo(Extensible extensible) {
        super.onAddingTo(extensible);
        JavaApplication application = this.getJavaApplication();
        int jmxRemotePort = Integer.parseInt(application.getSystemProperties().getProperty(SUN_MANAGEMENT_JMXREMOTE_PORT).toString());
        String jmxRemoteHostName = application.getSystemProperties().getProperty("java.rmi.server.hostname");
        jmxRemoteHostName = jmxRemoteHostName == null ? application.getPlatform().getAddress().getHostAddress() : jmxRemoteHostName;
        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", jmxRemoteHostName, jmxRemotePort);
        this.cachedJmxConnector = DeferredHelper.cached((Deferred)new DeferredJMXConnector(url));
    }

    public void onRemovingFrom(Extensible extensible) {
        super.onRemovingFrom(extensible);
        JMXConnector jmxConnector = (JMXConnector)this.cachedJmxConnector.release();
        if (jmxConnector != null) {
            try {
                jmxConnector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Deferred<JMXConnector> getDeferredJMXConnector() {
        return this.cachedJmxConnector;
    }

    public <T> Deferred<T> getDeferredMBeanAttribute(ObjectName objectName, String attributeName, Class<T> attributeClass) {
        return new DeferredMBeanAttribute(this.cachedJmxConnector, objectName, attributeName, attributeClass);
    }

    public <T> T getMBeanAttribute(ObjectName objectName, String attributeName, Class<T> attributeClass) {
        return (T)DeferredHelper.ensured(this.getDeferredMBeanAttribute(objectName, attributeName, attributeClass), (Option[])new Option[]{DeferredHelper.within((Timeout)this.getDefaultTimeout())}).get();
    }

    public <T> Deferred<T> getDeferredMBeanProxy(ObjectName objectName, Class<T> proxyClass) {
        return new Cached((Deferred)new DeferredMBeanProxy(this.cachedJmxConnector, objectName, proxyClass));
    }

    public <T> T getMBeanProxy(ObjectName objectName, Class<T> clazz) {
        return (T)DeferredHelper.ensured(this.getDeferredMBeanProxy(objectName, clazz), (Option[])new Option[]{DeferredHelper.within((Timeout)this.getDefaultTimeout())}).get();
    }

    public Deferred<MBeanInfo> getDeferredMBeanInfo(ObjectName objectName) {
        return new DeferredMBeanInfo(this.cachedJmxConnector, objectName);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        return (MBeanInfo)DeferredHelper.ensured(this.getDeferredMBeanInfo(objectName), (Option[])new Option[]{DeferredHelper.within((Timeout)this.getDefaultTimeout())}).get();
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            return ((JMXConnector)DeferredHelper.ensured(this.getDeferredJMXConnector(), (Option[])new Option[]{DeferredHelper.within((Timeout)this.getDefaultTimeout())}).get()).getMBeanServerConnection().queryMBeans(name, query);
        }
        catch (IOException e) {
            throw new PermanentlyUnavailableException(this.getDeferredJMXConnector(), (Throwable)e);
        }
    }

    public static JmxProfile enabled() {
        return JmxProfile.enabled();
    }

    public static JmxProfile authentication(boolean enabled) {
        return JmxProfile.authentication(enabled);
    }

    public static JmxProfile ssl(boolean enabled) {
        return JmxProfile.ssl(enabled);
    }

    public static JmxProfile hostname(String hostname) {
        return JmxProfile.hostname(hostname);
    }
}

