/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.profiles;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.io.NetworkHelper;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.JavaVirtualMachine;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import com.oracle.bedrock.runtime.java.options.WaitToStart;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.PerpetualIterator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;

public class RemoteDebugging
implements Profile,
Option {
    private boolean enabled;
    private boolean startSuspended;
    private Behavior behavior;
    private TransportAddress transportAddress;

    private RemoteDebugging(boolean enabled, boolean startSuspended, Behavior behavior, TransportAddress transportAddress) {
        this.enabled = enabled;
        this.startSuspended = startSuspended;
        this.behavior = behavior;
        this.transportAddress = transportAddress;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public TransportAddress getTransportAddress() {
        return this.transportAddress;
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (this.enabled) {
            TransportAddress transportAddress;
            TransportAddress transportAddress2 = transportAddress = this.transportAddress == null ? (TransportAddress)optionsByType.get(TransportAddress.class, new Object[0]) : this.transportAddress;
            if (transportAddress == null) {
                if (this.behavior == Behavior.LISTEN_FOR_DEBUGGER) {
                    transportAddress = new TransportAddress(LocalPlatform.get().getAvailablePorts());
                } else {
                    throw new IllegalStateException("Failed to specify a RemoteDebugging.TransportAddress option for attaching the debugger.");
                }
            }
            Object address = transportAddress.getInetAddress() == null ? ((Integer)transportAddress.getPort().get()).toString() : transportAddress.getInetAddress().getHostAddress() + ":" + transportAddress.getPort().get();
            boolean isDebugServer = this.behavior == Behavior.LISTEN_FOR_DEBUGGER;
            Agent agent = new Agent(String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=%s,address=%s", isDebugServer ? "y" : "n", this.startSuspended ? "y" : "n", address), transportAddress.getSocketAddress());
            optionsByType.add((Option)agent);
            if (this.startSuspended) {
                optionsByType.add((Option)WaitToStart.disabled());
            }
        }
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public static RemoteDebugging enabled() {
        return new RemoteDebugging(true, false, Behavior.LISTEN_FOR_DEBUGGER, null);
    }

    public static RemoteDebugging disabled() {
        return new RemoteDebugging(false, false, Behavior.LISTEN_FOR_DEBUGGER, null);
    }

    public RemoteDebugging startSuspended(boolean startSuspended) {
        return new RemoteDebugging(true, startSuspended, Behavior.LISTEN_FOR_DEBUGGER, null);
    }

    public RemoteDebugging attach() {
        return new RemoteDebugging(this.enabled, this.startSuspended, Behavior.ATTACH_TO_DEBUGGER, null);
    }

    public RemoteDebugging listen() {
        return new RemoteDebugging(this.enabled, this.startSuspended, Behavior.LISTEN_FOR_DEBUGGER, null);
    }

    public RemoteDebugging at(TransportAddress transportAddress) {
        return new RemoteDebugging(this.enabled, this.startSuspended, this.behavior, transportAddress);
    }

    public RemoteDebugging at(AvailablePortIterator ports) {
        return new RemoteDebugging(this.enabled, this.startSuspended, this.behavior, new TransportAddress(ports));
    }

    public RemoteDebugging at(Capture<Integer> port) {
        return new RemoteDebugging(this.enabled, this.startSuspended, this.behavior, new TransportAddress(port));
    }

    public RemoteDebugging at(InetAddress address, Capture<Integer> port) {
        return new RemoteDebugging(this.enabled, this.startSuspended, this.behavior, new TransportAddress(address, port));
    }

    public RemoteDebugging at(InetAddress address, int port) {
        return new RemoteDebugging(this.enabled, this.startSuspended, this.behavior, new TransportAddress(address, port));
    }

    @OptionsByType.Default
    public static RemoteDebugging autoDetect() {
        return new RemoteDebugging(JavaVirtualMachine.get().shouldEnableRemoteDebugging(), false, Behavior.LISTEN_FOR_DEBUGGER, null);
    }

    public static class TransportAddress
    implements Option {
        private InetAddress address;
        private Capture<Integer> port;

        public TransportAddress(AvailablePortIterator ports) {
            this((InetAddress)NetworkHelper.getInetAddresses(ports.getInetAddresses(), (Predicate)NetworkHelper.IPv4_ADDRESS).iterator().next(), (Capture<Integer>)new Capture((Iterator)ports));
        }

        public TransportAddress(Capture<Integer> port) {
            this(null, port);
        }

        public TransportAddress(int port) {
            this(null, (Capture<Integer>)new Capture((Iterator)new PerpetualIterator((Object)port)));
        }

        public TransportAddress(InetAddress address, Capture<Integer> port) {
            if (port == null) {
                throw new NullPointerException("The port for an address can't be null");
            }
            this.address = address;
            this.port = port;
        }

        public TransportAddress(InetAddress address, int port) {
            this(address, (Capture<Integer>)new Capture((Iterator)new PerpetualIterator((Object)port)));
        }

        public InetAddress getInetAddress() {
            return this.address;
        }

        public InetSocketAddress getSocketAddress() {
            return this.getInetAddress() == null ? null : new InetSocketAddress(this.getInetAddress(), (int)((Integer)this.port.get()));
        }

        public Capture<Integer> getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransportAddress)) {
                return false;
            }
            TransportAddress other = (TransportAddress)o;
            if (this.address != null ? !this.address.equals(other.address) : other.address != null) {
                return false;
            }
            return this.port.equals(other.port);
        }

        public int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + this.port.hashCode();
            return result;
        }
    }

    @Internal
    public static class Agent
    implements JvmOption {
        private String configuration;
        private InetSocketAddress address;

        public Agent(String configuration, InetSocketAddress address) {
            this.configuration = configuration;
            this.address = address;
        }

        public InetSocketAddress getSocketAddress() {
            return this.address;
        }

        @Override
        public Iterable<String> resolve(OptionsByType optionsByType) {
            ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
            return Collections.singletonList((String)evaluator.evaluate(this.configuration, String.class));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Agent)) {
                return false;
            }
            Agent agent = (Agent)o;
            return this.configuration != null ? this.configuration.equals(agent.configuration) : agent.configuration == null;
        }

        public int hashCode() {
            return this.configuration != null ? this.configuration.hashCode() : 0;
        }

        public String toString() {
            return "Agent{" + this.configuration + "}";
        }
    }

    public static enum Behavior {
        LISTEN_FOR_DEBUGGER,
        ATTACH_TO_DEBUGGER;

    }
}

