/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.console.EventsApplicationConsole;
import com.oracle.bedrock.testsupport.MavenProjectFileUtils;
import com.oracle.bedrock.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class TestLogs
extends TestName {
    private Class<?> m_clsTest;
    private String m_sMethodName;
    private File m_fileOutDir;

    public TestLogs() {
        this(null);
    }

    public TestLogs(Class<?> clsTest) {
        this.m_clsTest = clsTest;
    }

    public void starting(Description description) {
        super.starting(description);
        Class<?> cls = description.getTestClass();
        if (cls == null) {
            try {
                String sName = description.getClassName();
                cls = Class.forName(sName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.init(cls, description.getMethodName());
    }

    public void finished(Description description) {
        super.finished(description);
    }

    public void init(Class<?> clsTest, String sMethodName) {
        this.m_clsTest = clsTest;
        this.m_sMethodName = sMethodName;
        this.m_fileOutDir = MavenProjectFileUtils.ensureTestOutputBaseFolder(this.m_clsTest);
        this.m_fileOutDir.mkdirs();
    }

    public Class<?> getTestClass() {
        return this.m_clsTest;
    }

    public File getOutputFolder() {
        return this.m_fileOutDir;
    }

    public ConsoleBuilder builder() {
        return new ConsoleBuilder(this);
    }

    private Console buildConsole(String name) throws IOException {
        File dir = new File(this.m_fileOutDir, this.m_clsTest.getSimpleName());
        dir.mkdir();
        if (this.m_sMethodName != null && this.m_sMethodName.trim().length() > 0) {
            dir = new File(dir, this.m_sMethodName);
            dir.mkdir();
        }
        System.err.println("Logging output from application '" + name + "' to " + dir + File.separator + name + ".log");
        return new Console(new FileWriter(new File(dir, name + ".log")));
    }

    public static class Console
    extends EventsApplicationConsole {
        private final FileWriter writer;

        private Console(FileWriter writer) {
            this.writer = writer;
            this.withStdOutListener(this::write);
            this.withStdErrListener(this::write);
        }

        private void write(String line) {
            try {
                this.writer.write(line);
                this.writer.write(10);
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ConsoleBuilder
    implements ApplicationConsoleBuilder {
        private TestLogs m_testLogs;
        private List<Pair<Predicate<String>, EventsApplicationConsole.Listener>> stdOutListeners = new ArrayList<Pair<Predicate<String>, EventsApplicationConsole.Listener>>();
        private List<Pair<Predicate<String>, EventsApplicationConsole.Listener>> stdErrListeners = new ArrayList<Pair<Predicate<String>, EventsApplicationConsole.Listener>>();

        public ConsoleBuilder(TestLogs testLogs) {
            this.m_testLogs = testLogs;
        }

        public ApplicationConsole build(String name) {
            try {
                Console console = this.m_testLogs.buildConsole(name);
                this.stdOutListeners.stream().filter(pair -> pair.getX() == null).map(Pair::getY).forEach(arg_0 -> ((Console)console).withStdOutListener(arg_0));
                this.stdErrListeners.stream().filter(pair -> pair.getX() == null).map(Pair::getY).forEach(arg_0 -> ((Console)console).withStdErrListener(arg_0));
                this.stdOutListeners.stream().filter(pair -> pair.getX() != null).forEach(pair -> console.withStdOutListener((Predicate)pair.getX(), (EventsApplicationConsole.Listener)pair.getY()));
                this.stdErrListeners.stream().filter(pair -> pair.getX() != null).forEach(pair -> console.withStdErrListener((Predicate)pair.getX(), (EventsApplicationConsole.Listener)pair.getY()));
                return console;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void clearListeners() {
            this.stdErrListeners.clear();
            this.stdOutListeners.clear();
        }

        public ConsoleBuilder addStdOutListener(EventsApplicationConsole.Listener listener) {
            this.stdOutListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(null, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdOutListener(Predicate<String> predicate, EventsApplicationConsole.Listener listener) {
            this.stdOutListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(predicate, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdErrListener(EventsApplicationConsole.Listener listener) {
            this.stdErrListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(null, (Object)listener));
            return this;
        }

        public ConsoleBuilder addStdErrListener(Predicate<String> predicate, EventsApplicationConsole.Listener listener) {
            this.stdErrListeners.add((Pair<Predicate<String>, EventsApplicationConsole.Listener>)new Pair(predicate, (Object)listener));
            return this;
        }
    }
}

