/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.matchers;

import com.oracle.bedrock.testsupport.matchers.ThrowableMessageMatcher;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;

public class ThrowableMatcher<T>
extends BaseMatcher<T> {
    private Matcher<? super Throwable> matcher;

    private ThrowableMatcher(Matcher<? super Throwable> matcher) {
        this.matcher = matcher;
    }

    public static <T> ThrowableMatcher<T> willThrow(Class<? extends Throwable> throwableClass) {
        return new ThrowableMatcher<T>((Matcher<? super Throwable>)IsInstanceOf.instanceOf(throwableClass));
    }

    public static <T> ThrowableMatcher<T> willThrow(Matcher<? super Throwable> matcher) {
        return new ThrowableMatcher<T>(matcher);
    }

    public ThrowableMatcher<T> withMessage(Matcher<? super String> matcher) {
        return new ThrowableMatcher<T>((Matcher<? super Throwable>)AllOf.allOf(this.matcher, ThrowableMessageMatcher.message(matcher)));
    }

    public ThrowableMatcher<T> withMessage(String message) {
        return new ThrowableMatcher<T>((Matcher<? super Throwable>)AllOf.allOf(this.matcher, ThrowableMessageMatcher.message((Matcher<? super String>)Is.is((Object)message))));
    }

    public ThrowableMatcher<T> causedBy(Matcher<? super Throwable> matcher) {
        return new ThrowableMatcher<T>((Matcher<? super Throwable>)AllOf.allOf(this.matcher, matcher));
    }

    public Matcher<? super Throwable> getMatcher() {
        return this.matcher;
    }

    public boolean matches(Object o) {
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("throws a throwable matching ");
        this.matcher.describeTo(description);
    }
}

