/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import java.util.Properties;

public interface JUnitTestListener {
    public void junitStarted(Event var1);

    public void junitCompleted(Event var1);

    public void testRunStarted(Event var1);

    public void testRunFinished(Event var1);

    public void testClassStarted(Event var1);

    public void testClassFinished(Event var1);

    public void testStarted(Event var1);

    public void testSucceeded(Event var1);

    public void testAssumptionFailure(Event var1);

    public void testError(Event var1);

    public void testFailed(Event var1);

    public void testIgnored(Event var1);

    public static class Event
    implements RemoteEvent {
        private final Type type;
        private final String className;
        private final String name;
        private final StackTraceElement[] stackTrace;
        private final long time;
        private final String exception;
        private final String message;
        private final Properties properties;

        private Event(Type type, String name, String className, long time, String exception, String message, StackTraceElement[] stackTrace, Properties properties) {
            this.type = type;
            this.name = name;
            this.className = className;
            this.time = time;
            this.exception = exception;
            this.message = message;
            this.stackTrace = stackTrace;
            this.properties = properties;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public long getTime() {
            return this.time;
        }

        public String getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public boolean isSkipped() {
            return this.type == Type.testAssumptionFailure || this.type == Type.testIgnored;
        }

        public boolean isFailure() {
            return this.type == Type.testFailure;
        }

        public boolean isError() {
            return this.type == Type.testError;
        }

        public String toString() {
            return "JUnitTestListener.Event(type=" + this.type + ", name='" + this.name + "', className='" + this.className + "', time=" + this.time + ", message='" + this.message + "')";
        }

        public static Event junitStarted() {
            return new Event(Type.JUnitStarted, "Start", null, 0L, null, null, null, null);
        }

        public static Event junitCompleted(long time) {
            return new Event(Type.JUnitCompleted, "End", null, time, null, null, null, null);
        }

        public static Event testRunStarted(String name, Properties properties) {
            return new Event(Type.testRunStarted, name, null, 0L, null, null, null, properties);
        }

        public static Event testRunFinsihed(String name, long time) {
            return new Event(Type.testRunFinished, name, null, time, null, null, null, null);
        }

        public static Event testClassStarted(String className) {
            return new Event(Type.testClassStarted, null, className, 0L, null, null, null, null);
        }

        public static Event testClassFinished(String className, long time) {
            return new Event(Type.testClassFinished, null, className, time, null, null, null, null);
        }

        public static Event testStarted(String name, String className) {
            return new Event(Type.testStarted, name, className, 0L, null, null, null, null);
        }

        public static Event testSucceded(String name, String className, long time) {
            return new Event(Type.testSuccess, name, className, time, null, null, null, null);
        }

        public static Event ignored(String name, String className, String message) {
            return new Event(Type.testIgnored, name, className, 0L, null, message, null, null);
        }

        public static Event failure(String name, String className, long time, String exception, String message, StackTraceElement[] stackTrace) {
            return new Event(Type.testFailure, name, className, time, exception, message, stackTrace, null);
        }

        public static Event error(String name, String className, long time, String exception, String message, StackTraceElement[] stackTrace) {
            return new Event(Type.testError, name, className, time, exception, message, stackTrace, null);
        }

        public static Event assumptionFailure(String name, String className, long time, String message, StackTraceElement[] stackTrace) {
            return new Event(Type.testAssumptionFailure, name, className, time, null, message, stackTrace, null);
        }

        public static enum Type {
            JUnitStarted,
            JUnitCompleted,
            testRunStarted,
            testRunFinished,
            testClassStarted,
            testClassFinished,
            testStarted,
            testSuccess,
            testIgnored,
            testAssumptionFailure,
            testFailure,
            testError;

        }
    }
}

