/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.options.StreamName;
import com.oracle.bedrock.testsupport.junit.JUnitTestListener;
import com.oracle.bedrock.testsupport.junit.JUnitUtils;
import com.oracle.bedrock.testsupport.junit.options.TestClasses;
import com.oracle.bedrock.testsupport.junit.options.Tests;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestRunner
implements Runnable {
    public static final StreamName STREAM_NAME = StreamName.of((String)"JUnit");
    public static final JUnitTestRunner INSTANCE = new JUnitTestRunner();
    public static RemoteChannel channel;
    private State state = State.NotRunning;
    private final Object MONITOR = new Object();
    private OptionsByType optionsByType;

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block27: {
            RemoteChannel.AcknowledgeWhen acknowledge;
            Object object;
            Object object2 = this.MONITOR;
            synchronized (object2) {
                if (this.state == State.NotRunning) {
                    this.state = State.Waiting;
                }
                this.awaitStateChangeFrom(State.Waiting);
            }
            if (this.state != State.Running) break block27;
            long start = System.currentTimeMillis();
            try {
                if (channel != null) {
                    channel.raise((RemoteEvent)JUnitTestListener.Event.junitStarted(), new Option[]{STREAM_NAME});
                }
                this.runTests(this.optionsByType);
                object = this.MONITOR;
            }
            catch (Throwable e2) {
                RemoteChannel.AcknowledgeWhen acknowledge2;
                Object e2;
                try {
                    e2.printStackTrace();
                    e2 = this.MONITOR;
                }
                catch (Throwable throwable2) {
                    RemoteChannel.AcknowledgeWhen acknowledge3;
                    Object object3 = this.MONITOR;
                    synchronized (object3) {
                        if (this.state == State.Running) {
                            this.state = State.Completed;
                            this.MONITOR.notifyAll();
                        }
                    }
                    long end = System.currentTimeMillis();
                    RemoteChannel.AcknowledgeWhen acknowledgeWhen = acknowledge3 = this.state != State.Stopped ? RemoteChannel.AcknowledgeWhen.PROCESSED : RemoteChannel.AcknowledgeWhen.SENT;
                    if (channel != null) {
                        CompletableFuture future = channel.raise((RemoteEvent)JUnitTestListener.Event.junitCompleted(end - start), new Option[]{STREAM_NAME, acknowledge3});
                        future.whenComplete((_void, throwable) -> this.changeState(State.Stopped));
                    } else {
                        this.changeState(State.Stopped);
                    }
                    throw throwable2;
                }
                synchronized (e2) {
                    if (this.state == State.Running) {
                        this.state = State.Completed;
                        this.MONITOR.notifyAll();
                    }
                }
                long end = System.currentTimeMillis();
                RemoteChannel.AcknowledgeWhen acknowledgeWhen = acknowledge2 = this.state != State.Stopped ? RemoteChannel.AcknowledgeWhen.PROCESSED : RemoteChannel.AcknowledgeWhen.SENT;
                if (channel != null) {
                    CompletableFuture future = channel.raise((RemoteEvent)JUnitTestListener.Event.junitCompleted(end - start), new Option[]{STREAM_NAME, acknowledge2});
                    future.whenComplete((_void, throwable) -> this.changeState(State.Stopped));
                } else {
                    this.changeState(State.Stopped);
                }
            }
            synchronized (object) {
                if (this.state == State.Running) {
                    this.state = State.Completed;
                    this.MONITOR.notifyAll();
                }
            }
            long end = System.currentTimeMillis();
            RemoteChannel.AcknowledgeWhen acknowledgeWhen = acknowledge = this.state != State.Stopped ? RemoteChannel.AcknowledgeWhen.PROCESSED : RemoteChannel.AcknowledgeWhen.SENT;
            if (channel != null) {
                CompletableFuture future = channel.raise((RemoteEvent)JUnitTestListener.Event.junitCompleted(end - start), new Option[]{STREAM_NAME, acknowledge});
                future.whenComplete((_void, throwable) -> this.changeState(State.Stopped));
            } else {
                this.changeState(State.Stopped);
            }
            this.awaitStateChangeTo(State.Stopped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State state) {
        Object object = this.MONITOR;
        synchronized (object) {
            this.state = state;
            this.MONITOR.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitStateChangeFrom(State currentState) {
        Object object = this.MONITOR;
        synchronized (object) {
            while (this.state == currentState) {
                try {
                    this.MONITOR.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.state = State.Stopped;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitStateChangeTo(State nextState) {
        Object object = this.MONITOR;
        synchronized (object) {
            while (this.state != nextState) {
                try {
                    this.MONITOR.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    private void runTests(OptionsByType optionsByType) {
        if (optionsByType == null) {
            return;
        }
        Tests tests = (Tests)optionsByType.get(Tests.class, new Object[0]);
        if (tests.isEmpty()) {
            return;
        }
        JUnitCore jUnitCore = new JUnitCore();
        Result result = new Result();
        Listener listener = new Listener();
        jUnitCore.addListener(result.createListener());
        jUnitCore.addListener((RunListener)listener);
        for (RunListener runListener : optionsByType.getInstancesOf(RunListener.class)) {
            jUnitCore.addListener(runListener);
        }
        Iterator<Object> iterator = tests.iterator();
        while (iterator.hasNext()) {
            TestClasses testClasses = (TestClasses)iterator.next();
            Set<Class<?>> classes = testClasses.resolveTestClasses();
            Filter filter = testClasses.getTestFilter();
            for (Class<?> testClass : classes) {
                Request request = Request.aClass(testClass);
                if (filter != null) {
                    request = request.filterWith(filter);
                }
                jUnitCore.run(request);
                if (this.state != State.Stopped) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(OptionsByType optionsByType) {
        Object object = this.MONITOR;
        synchronized (object) {
            while (this.state == State.NotRunning) {
                try {
                    this.MONITOR.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (this.state != State.Waiting) {
                throw new IllegalStateException("JUnit runner is not in a valid state to accept tests. State=" + this.state);
            }
            this.optionsByType = optionsByType;
            this.state = State.Running;
            this.MONITOR.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.state == State.Stopped) {
            return;
        }
        Object object = this.MONITOR;
        synchronized (object) {
            this.state = State.Stopped;
            this.MONITOR.notifyAll();
        }
    }

    public static void main(String[] args) {
        channel = RemoteChannel.get();
        INSTANCE.run();
    }

    public static enum State {
        NotRunning,
        Waiting,
        Running,
        Completed,
        Stopped;

    }

    public static class Listener
    extends RunListener {
        private final ThreadLocal<Description> testRunDescription = new InheritableThreadLocal<Description>();
        private final ThreadLocal<String> currentTestClass = new InheritableThreadLocal<String>();
        private final ThreadLocal<Boolean> testFailed = new InheritableThreadLocal<Boolean>();
        private final ThreadLocal<Long> runStartTime = new InheritableThreadLocal<Long>();
        private final ThreadLocal<Long> classStartTime = new InheritableThreadLocal<Long>();
        private final ThreadLocal<Long> testStartTime = new InheritableThreadLocal<Long>();

        public Description getTestRunDescription() {
            return this.testRunDescription.get();
        }

        public String getCurrentTestClass() {
            return this.currentTestClass.get();
        }

        public Long getClassStartTime() {
            return this.classStartTime.get();
        }

        public Long getRunStartTime() {
            return this.runStartTime.get();
        }

        public Long getTestStartTime() {
            return this.testStartTime.get();
        }

        public Boolean hasTestFailed() {
            return this.testFailed.get();
        }

        public void setTestFailed(boolean failed) {
            this.testFailed.set(failed);
        }

        public void testRunStarted(Description description) throws Exception {
            this.currentTestClass.set(null);
            this.setTestFailed(false);
            this.testRunDescription.set(description);
            this.raiseEvent(JUnitTestListener.Event.testRunStarted(description.getDisplayName(), System.getProperties()));
            this.runStartTime.set(System.currentTimeMillis());
        }

        public void testRunFinished(Result result) throws Exception {
            long endTime = System.currentTimeMillis();
            long time = endTime - this.runStartTime.get();
            Description description = this.testRunDescription.get();
            Long classStart = this.classStartTime.get();
            long classRunTime = classStart != null ? endTime - classStart : 0L;
            String currentClassName = this.currentTestClass.get();
            if (currentClassName != null) {
                this.raiseEvent(JUnitTestListener.Event.testClassFinished(currentClassName, classRunTime));
            }
            this.raiseEvent(JUnitTestListener.Event.testRunFinsihed(description.getDisplayName(), time));
        }

        public void testStarted(Description description) throws Exception {
            this.checkClassChange(description);
            this.setTestFailed(false);
            this.raiseEvent(JUnitTestListener.Event.testStarted(description.getDisplayName(), JUnitUtils.findClassName(description)));
            this.testStartTime.set(System.currentTimeMillis());
        }

        public void testFinished(Description description) throws Exception {
            Boolean isFailure = this.hasTestFailed();
            if (isFailure == null || !isFailure.booleanValue()) {
                long endTime = System.currentTimeMillis();
                long time = endTime - this.testStartTime.get();
                this.raiseEvent(JUnitTestListener.Event.testSucceded(description.getDisplayName(), JUnitUtils.findClassName(description), time));
            }
        }

        public void testIgnored(Description description) throws Exception {
            this.checkClassChange(description);
            this.raiseEvent(JUnitTestListener.Event.ignored(description.getDisplayName(), JUnitUtils.findClassName(description), JUnitUtils.getIgnoredMessage(description)));
        }

        public void testAssumptionFailure(Failure failure) {
            long endTime = System.currentTimeMillis();
            long time = endTime - this.testStartTime.get();
            Description description = failure.getDescription();
            Throwable throwable = failure.getException();
            String testHeader = failure.getTestHeader();
            if (testHeader == null || "null".equals(testHeader)) {
                testHeader = "Failed to construct test";
            }
            this.raiseEvent(JUnitTestListener.Event.assumptionFailure(testHeader, JUnitUtils.findClassName(description), time, throwable.getMessage(), throwable.getStackTrace()));
            this.setTestFailed(true);
        }

        public void testFailure(Failure failure) throws Exception {
            long endTime = System.currentTimeMillis();
            long time = endTime - this.testStartTime.get();
            Description description = failure.getDescription();
            Throwable cause = failure.getException();
            if (cause instanceof AssertionError) {
                this.raiseEvent(JUnitTestListener.Event.failure(JUnitUtils.getFailureMessage(failure), JUnitUtils.findClassName(description), time, cause.getClass().getCanonicalName(), cause.getMessage(), cause.getStackTrace()));
            } else {
                this.raiseEvent(JUnitTestListener.Event.error(JUnitUtils.getFailureMessage(failure), JUnitUtils.findClassName(description), time, cause.getClass().getCanonicalName(), cause.getMessage(), cause.getStackTrace()));
            }
            this.setTestFailed(true);
        }

        protected void checkClassChange(Description description) {
            long endTime = System.currentTimeMillis();
            String testClass = JUnitUtils.findClassName(description);
            String current = this.currentTestClass.get();
            if (current == null || !current.equals(testClass)) {
                if (current != null) {
                    long time = endTime - this.classStartTime.get();
                    this.raiseEvent(JUnitTestListener.Event.testClassFinished(current, time));
                }
                this.raiseEvent(JUnitTestListener.Event.testClassStarted(JUnitUtils.findClassName(description)));
                this.classStartTime.set(System.currentTimeMillis());
                this.currentTestClass.set(testClass);
            }
        }

        protected void raiseEvent(JUnitTestListener.Event event) {
            if (channel != null) {
                channel.raise((RemoteEvent)event, new Option[]{STREAM_NAME});
            }
        }
    }

    public static class StopTests
    implements RemoteRunnable {
        private transient JUnitTestRunner runner = INSTANCE;

        public void setRunner(JUnitTestRunner runner) {
            this.runner = runner;
        }

        public void run() {
            if (this.runner == null) {
                this.runner = INSTANCE;
            }
            this.runner.stop();
        }
    }

    public static class StartTests
    implements RemoteCallable<Boolean> {
        private transient JUnitTestRunner runner = INSTANCE;
        private Option[] options;

        public StartTests(OptionsByType optionsByType) {
            ArrayList list = new ArrayList();
            Iterable serializables = optionsByType.getInstancesOf(Serializable.class);
            serializables.forEach(opt -> list.add(opt instanceof Option ? (Option)opt : Decoration.of((Object)opt)));
            this.options = list.toArray(new Option[list.size()]);
        }

        Option[] getOptions() {
            return this.options;
        }

        public Boolean call() {
            if (this.runner == null) {
                this.runner = INSTANCE;
            }
            this.runner.run(OptionsByType.of((Option[])this.options));
            return true;
        }

        public void setRunner(JUnitTestRunner runner) {
            this.runner = runner;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.options.length);
            for (Option option : this.options) {
                out.writeObject(option);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            this.options = new Option[length];
            for (int i = 0; i < length; ++i) {
                this.options[i] = (Option)in.readObject();
            }
        }
    }
}

