/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.junit.Assert;

public class MavenProjectFileUtils {
    public static File locateBuildFolder(Class classTest) {
        File buildFolder;
        String buildFolderProperty = System.getProperty("project.build.directory");
        if (buildFolderProperty == null || buildFolderProperty.trim().isEmpty()) {
            try {
                URL url = classTest.getProtectionDomain().getCodeSource().getLocation();
                File file = new File(url.toURI());
                while (!file.getName().equals("target")) {
                    file = file.getParentFile();
                }
                buildFolder = file;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            buildFolder = new File(buildFolderProperty);
            if (buildFolder.exists()) {
                if (!buildFolder.isDirectory()) {
                    Assert.fail((String)("The project.build.directory property is not a directory: " + buildFolderProperty));
                }
            } else {
                Assert.fail((String)("The project.build.directory property was set to a non-existent folder: " + buildFolderProperty));
            }
        }
        return buildFolder;
    }

    public static File ensureTestOutputBaseFolder(Class classTest) {
        File fileBuild = MavenProjectFileUtils.ensureFolders(MavenProjectFileUtils.locateBuildFolder(classTest));
        File fileTestOut = MavenProjectFileUtils.ensureFolders(new File(fileBuild, "test-output"));
        return MavenProjectFileUtils.ensureFolders(new File(fileTestOut, "functional"));
    }

    public static File ensureTestOutputFolder(Class classTest, String sSuffix) {
        File fileBuild = MavenProjectFileUtils.ensureFolders(MavenProjectFileUtils.locateBuildFolder(classTest));
        File fileTestOut = MavenProjectFileUtils.ensureFolders(new File(fileBuild, "test-output"));
        File fileTestOutFunctional = MavenProjectFileUtils.ensureFolders(new File(fileTestOut, "functional"));
        File fileTest = new File(fileTestOutFunctional, classTest.getSimpleName());
        if (sSuffix != null && !sSuffix.trim().isEmpty()) {
            fileTest = new File(fileTest, sSuffix);
        }
        return MavenProjectFileUtils.ensureFolders(fileTest);
    }

    private static File ensureFolders(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static void recursiveDelete(File folder) {
        if (folder.exists()) {
            File[] files = folder.listFiles();
            if (files != null) {
                for (File each : files) {
                    MavenProjectFileUtils.recursiveDelete(each);
                }
            }
            try {
                Files.delete(folder.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean fileContains(File file, String regex) {
        try {
            Stream<String> stream = Files.lines(file.toPath());
            return stream.anyMatch(s -> s.matches(regex));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("There was an error while reading the file" + file));
            return false;
        }
    }
}

