/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredFunction;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.Existing;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.options.InitialDelay;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.testsupport.deferred.DeferredMatch;
import com.oracle.bedrock.testsupport.deferred.DeferredRemoteExecution;
import java.io.NotSerializableException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class Eventually {
    public static <T> void assertDeferred(Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Eventually.assertDeferred(null, deferred, matcher, options);
    }

    public static <T> void assertDeferred(String message, Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(message, deferred, matcher, options);
    }

    public static <T> void assertThat(T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(null, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T> void assertThat(String message, T value, Matcher<? super T> matcher) throws AssertionError {
        Eventually.assertThat(message, DeferredHelper.eventually(value), matcher, new Option[0]);
    }

    public static <T> void assertThat(String message, T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(message, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T, R> void assertThat(T value, Function<T, R> function, Matcher<? super R> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(DeferredHelper.eventually(value), function, matcher, options);
    }

    public static <T, R> void assertThat(Deferred<T> deferred, Function<T, R> function, Matcher<? super R> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(null, new DeferredFunction(deferred, function), matcher, options);
    }

    public static <T> void assertThat(String message, Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        DeferredMatch<T> deferredMatch = new DeferredMatch<T>(deferred, matcher);
        try {
            DeferredHelper.ensure(deferredMatch, (Option[])options);
        }
        catch (PermanentlyUnavailableException e) {
            AssertionError error;
            String cause = "";
            if (deferredMatch.getLastUsedMatchValue() == null) {
                if (e.getCause() instanceof NotSerializableException) {
                    cause = " (NotSerializableException thrown)";
                }
                error = new AssertionError((Object)((String)(message == null ? "" : message + ": ") + "Failed to resolve a value for [" + deferredMatch.getDeferred() + "] to evaluate with matcher [" + deferredMatch.getMatcher() + "]" + cause));
                ((Throwable)((Object)error)).initCause(e);
            } else {
                if (deferred instanceof Existing) {
                    cause = ", (Deferred was not retried as it was a simple value)";
                }
                StringDescription description = new StringDescription();
                matcher.describeMismatch(deferredMatch.getLastUsedMatchValue(), (Description)description);
                error = new AssertionError((Object)((String)(message == null ? "" : message + ": ") + "Matcher [" + matcher + "] failed to match last resolved value [" + deferredMatch.getLastUsedMatchValue() + "] for [" + deferredMatch.getDeferred() + "]" + cause + " due to " + description.toString()));
                ((Throwable)((Object)error)).initCause(e);
            }
            throw error;
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)((String)(message == null ? "" : message + ": ") + "Unexpected exception when attempting to resolve a value for [" + deferredMatch.getDeferred() + "] to evaluate with matcher [" + deferredMatch.getMatcher() + "]"));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    public static <T> void assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher) throws AssertionError {
        Eventually.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, new Option[0]);
    }

    public static <T> void assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Eventually.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, options);
    }

    public static Timeout within(long duration, TimeUnit units) {
        return Timeout.after((long)duration, (TimeUnit)units);
    }

    public static InitialDelay delayedBy(long duration, TimeUnit units) {
        return InitialDelay.of((long)duration, (TimeUnit)units);
    }
}

