/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.testsupport.junit.TestClassPredicate;
import com.oracle.bedrock.testsupport.junit.options.Tests;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public abstract class TestClasses
implements Option.Collectable,
Option,
Serializable {
    private final Set<TestMatcher> includePatterns = new HashSet<TestMatcher>();
    private final Set<TestMatcher> excludePatterns = new HashSet<TestMatcher>();
    private final Predicate<Class<?>> testClassPredicate = new TestClassPredicate();

    public abstract Set<Class<?>> resolveTestClasses();

    public TestClasses include(String ... patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (pattern.isEmpty()) continue;
                this.includePatterns.add(new TestMatcher(pattern));
            }
        }
        return this;
    }

    public TestClasses exclude(String ... patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (pattern.isEmpty()) continue;
                this.excludePatterns.add(new TestMatcher(pattern));
            }
        }
        return this;
    }

    public Filter getTestFilter() {
        if (this.includePatterns.isEmpty() && this.excludePatterns.isEmpty()) {
            return AlwaysRunFilter.INSTANCE;
        }
        return new TestFilter(this.includePatterns, this.excludePatterns);
    }

    protected Predicate<Class<?>> getTestClassPredicate() {
        if (this.includePatterns.isEmpty() && this.excludePatterns.isEmpty()) {
            return this.testClassPredicate;
        }
        return new IncludeExcludePredicate(this.testClassPredicate, this.includePatterns, this.excludePatterns);
    }

    public Class<? extends Option.Collector> getCollectorClass() {
        return Tests.class;
    }

    public static TestClasses of(Class<?> ... classes) {
        if (classes.length == 0) {
            return TestClasses.empty();
        }
        return new SpecificClasses(classes);
    }

    public static TestClasses from(ClassPath classPath) {
        if (classPath == null || classPath.isEmpty()) {
            return TestClasses.empty();
        }
        return new ClassPathClasses(classPath);
    }

    @OptionsByType.Default
    public static TestClasses empty() {
        return new TestClasses(){

            @Override
            public Set<Class<?>> resolveTestClasses() {
                return Collections.emptySet();
            }
        };
    }

    protected static class TestMatcher
    implements Serializable {
        private String classPattern;
        private String methodPattern;

        protected TestMatcher(String pattern) {
            int index = pattern.indexOf(35);
            if (index < 0) {
                this.classPattern = pattern.trim();
            } else if (index == 0) {
                this.methodPattern = pattern.substring(1).trim();
            } else {
                this.classPattern = pattern.substring(0, index).trim();
                this.methodPattern = pattern.substring(index + 1, pattern.length()).trim();
            }
        }

        public String getClassPattern() {
            return this.classPattern;
        }

        public String getMethodPattern() {
            return this.methodPattern;
        }

        public boolean matches(String className) {
            return this.classPattern == null || className.matches(this.classPattern);
        }

        public boolean matches(String className, String methodName) {
            if (this.classPattern == null || className.matches(this.classPattern)) {
                return this.methodPattern == null || methodName.matches(this.methodPattern);
            }
            return false;
        }

        public boolean hasClassPattern() {
            return this.classPattern != null && !this.classPattern.isEmpty();
        }

        public boolean hasMethodPattern() {
            return this.methodPattern != null && !this.methodPattern.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestMatcher that = (TestMatcher)o;
            if (this.classPattern != null ? !this.classPattern.equals(that.classPattern) : that.classPattern != null) {
                return false;
            }
            return this.methodPattern != null ? this.methodPattern.equals(that.methodPattern) : that.methodPattern == null;
        }

        public int hashCode() {
            int result = this.classPattern != null ? this.classPattern.hashCode() : 0;
            result = 31 * result + (this.methodPattern != null ? this.methodPattern.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TestMatcher(classPattern='" + this.classPattern + "', methodPattern='" + this.methodPattern + "')";
        }
    }

    public static class AlwaysRunFilter
    extends Filter {
        public static final AlwaysRunFilter INSTANCE = new AlwaysRunFilter();

        public String describe() {
            return "AlwaysRunFilter";
        }

        public boolean shouldRun(Description description) {
            return true;
        }
    }

    protected static class TestFilter
    extends Filter {
        private final Set<TestMatcher> includePatterns;
        private final Set<TestMatcher> excludePatterns;

        public TestFilter(Set<TestMatcher> includePatterns, Set<TestMatcher> excludePatterns) {
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
        }

        public String describe() {
            return "TestClasses Filter";
        }

        public boolean shouldRun(Description description) {
            if (description.isSuite()) {
                return true;
            }
            if (!description.isTest()) {
                return false;
            }
            String name = description.getDisplayName();
            String className = null;
            String methodName = null;
            if (name != null) {
                int index;
                if ((name = name.trim()).endsWith(")") && (index = name.lastIndexOf(40)) != -1) {
                    className = name.substring(index + 1, name.length() - 1).trim();
                    methodName = name.substring(0, index).trim();
                }
            } else {
                return false;
            }
            if (className == null || className.isEmpty() || methodName == null || methodName.isEmpty()) {
                return false;
            }
            boolean included = this.includePatterns.isEmpty();
            for (TestMatcher matcher : this.includePatterns) {
                if (!matcher.matches(className, methodName)) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
            for (TestMatcher matcher : this.excludePatterns) {
                if (!matcher.matches(className, methodName)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IncludeExcludePredicate
    implements Predicate<Class<?>> {
        private Set<TestMatcher> includePatterns = new HashSet<TestMatcher>();
        private Set<TestMatcher> excludePatterns = new HashSet<TestMatcher>();
        private final Predicate<Class<?>> predicate;

        protected IncludeExcludePredicate(Predicate<Class<?>> predicate, Set<TestMatcher> includePatterns, Set<TestMatcher> excludePatterns) {
            this.predicate = predicate;
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
        }

        @Override
        public boolean test(Class<?> testClass) {
            if (testClass == null) {
                return false;
            }
            if (!this.predicate.test(testClass)) {
                return false;
            }
            String className = testClass.getCanonicalName();
            boolean include = this.includePatterns.isEmpty();
            for (TestMatcher matcher : this.includePatterns) {
                if (matcher.hasClassPattern() && !matcher.matches(className)) continue;
                include = true;
                break;
            }
            if (include) {
                for (TestMatcher matcher : this.excludePatterns) {
                    if (matcher.hasMethodPattern() || !matcher.matches(className)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class SpecificClasses
    extends TestClasses
    implements Serializable {
        private Set<String> classNames;
        private transient Set<Class<?>> classes;

        private SpecificClasses(Class<?> ... classes) {
            this.classNames = new HashSet<String>(classes.length);
            for (Class<?> cls : classes) {
                this.classNames.add(cls.getCanonicalName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Class<?>> resolveTestClasses() {
            if (this.classes == null) {
                SpecificClasses specificClasses = this;
                synchronized (specificClasses) {
                    if (this.classes == null) {
                        HashSet classes = new HashSet();
                        Predicate<Class<?>> predicate = this.getTestClassPredicate();
                        for (String className : this.classNames) {
                            try {
                                Class<?> testClass = Class.forName(className);
                                if (!predicate.test(testClass)) continue;
                                classes.add(testClass);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        this.classes = classes;
                    }
                }
            }
            return Collections.unmodifiableSet(this.classes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecificClasses that = (SpecificClasses)o;
            return this.classNames.equals(that.classNames);
        }

        public int hashCode() {
            return this.classNames.hashCode();
        }

        public String toString() {
            return "TestClasses(classNames=" + String.valueOf(this.classNames) + ")";
        }
    }

    protected static class ClassPathClasses
    extends TestClasses
    implements Serializable {
        private String[] paths;
        private transient Set<Class<?>> classes;

        public ClassPathClasses(ClassPath classPath) {
            this.paths = new String[classPath.size()];
            int index = 0;
            for (String path : classPath) {
                this.paths[index++] = path;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Class<?>> resolveTestClasses() {
            if (this.classes == null) {
                ClassPathClasses classPathClasses = this;
                synchronized (classPathClasses) {
                    if (this.classes == null) {
                        try {
                            HashSet testClasses = new HashSet();
                            ClassPath classPath = new ClassPath(this.paths);
                            URL[] urLs = classPath.getURLs();
                            ArrayList<Path> paths = new ArrayList<Path>();
                            Predicate<Class<?>> predicate = this.getTestClassPredicate();
                            for (URL url : urLs) {
                                paths.add(Paths.get(url.toURI()));
                            }
                            for (Path path : paths) {
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    testClasses.addAll(this.walkPath(path, predicate));
                                    continue;
                                }
                                String fileName = path.getFileName().toString();
                                if (!Files.isRegularFile(path, new LinkOption[0]) || !ClassPath.isResourceAnArchive((String)fileName)) continue;
                                FileSystem fileSystem = FileSystems.newFileSystem(path, (ClassLoader)null);
                                testClasses.addAll(this.walkFileSystem(fileSystem, predicate));
                            }
                            this.classes = testClasses;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(this.classes);
        }

        private Set<Class<?>> walkFileSystem(FileSystem fileSystem, Predicate<Class<?>> predicate) throws IOException {
            HashSet testClasses = new HashSet();
            for (Path path : fileSystem.getRootDirectories()) {
                testClasses.addAll(this.walkPath(path, predicate));
            }
            return testClasses;
        }

        private List<Class<?>> walkPath(final Path path, final Predicate<Class<?>> predicate) throws IOException {
            final ArrayList testClasses = new ArrayList();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        StringBuilder className = new StringBuilder();
                        Iterator<Path> iterator = path.relativize(file).iterator();
                        while (iterator.hasNext()) {
                            String name = iterator.next().toString();
                            if (iterator.hasNext()) {
                                className.append(name).append('.');
                                continue;
                            }
                            className.append(name.substring(0, name.length() - 6));
                        }
                        try {
                            Class<?> testClass = Class.forName(className.toString());
                            if (predicate.test(testClass)) {
                                testClasses.add(testClass);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return testClasses;
        }
    }
}

