/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.testsupport.junit.JUnitTestListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JUnitReporter
implements JUnitTestListener {
    private Map<String, TestResults> results = new ConcurrentHashMap<String, TestResults>();
    private final File reportFolder;
    private Properties testProperties;

    protected JUnitReporter(File reportFolder) {
        this.reportFolder = reportFolder;
    }

    public File getReportFolder() {
        return this.reportFolder;
    }

    public TestResults ensureTest(String className) {
        return this.results.computeIfAbsent(className, TestResults::new);
    }

    public Properties getTestProperties() {
        return this.testProperties;
    }

    public Option asOption() {
        return Decoration.of((Object)this);
    }

    public abstract void writeReport(PrintStream var1, TestResults var2);

    public abstract String getReportFileName(String var1);

    @Override
    public void junitStarted(JUnitTestListener.Event event) {
    }

    @Override
    public void junitCompleted(JUnitTestListener.Event event) {
    }

    @Override
    public void testRunStarted(JUnitTestListener.Event event) {
        String className = event.getClassName();
        if (className != null) {
            this.ensureTest(className).addEvent(event);
        }
        this.testProperties = event.getProperties();
    }

    @Override
    public void testRunFinished(JUnitTestListener.Event event) {
    }

    @Override
    public void testStarted(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.incrementTestCount();
    }

    @Override
    public void testClassStarted(JUnitTestListener.Event event) {
    }

    @Override
    public void testClassFinished(JUnitTestListener.Event event) {
        String className = event.getClassName();
        if (className == null) {
            return;
        }
        TestResults test = this.ensureTest(className);
        float time = (float)event.getTime() / 1000.0f;
        test.setTestTimeSeconds(time);
        File reportFolder = this.getReportFolder();
        if (reportFolder == null) {
            this.writeReport(System.out, test);
        } else {
            try {
                String fileName = this.getReportFileName(className);
                File reportFile = new File(reportFolder, fileName);
                try (PrintStream out = new PrintStream(reportFile);){
                    this.writeReport(out, test);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void testSucceeded(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.addEvent(event);
    }

    @Override
    public void testIgnored(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.addEvent(event);
        test.incrementSkipCount();
    }

    @Override
    public void testFailed(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.addEvent(event);
        test.incrementFailureCount();
    }

    @Override
    public void testError(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.addEvent(event);
        test.incrementErrorCount();
    }

    @Override
    public void testAssumptionFailure(JUnitTestListener.Event event) {
        TestResults test = this.ensureTest(event.getClassName());
        test.addEvent(event);
        test.incrementSkipCount();
    }

    public static class TestResults {
        private AtomicInteger testCount = new AtomicInteger(0);
        private AtomicInteger skipCount = new AtomicInteger(0);
        private AtomicInteger failureCount = new AtomicInteger(0);
        private AtomicInteger errorCount = new AtomicInteger(0);
        private Queue<JUnitTestListener.Event> events = new ConcurrentLinkedQueue<JUnitTestListener.Event>();
        private final String className;
        private float testTimeSeconds;

        public TestResults(String className) {
            this.className = className;
        }

        public void addEvent(JUnitTestListener.Event event) {
            this.events.add(event);
        }

        public Queue<JUnitTestListener.Event> getEvents() {
            return this.events;
        }

        public String getClassName() {
            return this.className;
        }

        public void setTestTimeSeconds(float seconds) {
            this.testTimeSeconds = seconds;
        }

        public float getTestTime() {
            return this.testTimeSeconds;
        }

        public void incrementTestCount() {
            this.testCount.incrementAndGet();
        }

        public int getTestCount() {
            return this.testCount.get();
        }

        public void incrementSkipCount() {
            this.skipCount.incrementAndGet();
        }

        public int getSkipCount() {
            return this.skipCount.get();
        }

        public void incrementFailureCount() {
            this.failureCount.incrementAndGet();
        }

        public int getFailureCount() {
            return this.failureCount.get();
        }

        public void incrementErrorCount() {
            this.errorCount.incrementAndGet();
        }

        public int getErrorCount() {
            return this.errorCount.get();
        }
    }
}

