/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.events;

import com.oracle.coherence.cdi.events.AnnotatedMapListener;
import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.MapEventTransformerFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotatedMapListenerManager {
    private final AnnotatedMapListener.FilterProducer f_filterProducer;
    private final AnnotatedMapListener.MapEventTransformerProducer f_transformerProducer;
    private final Map<String, Map<String, Set<AnnotatedMapListener<?, ?>>>> m_mapListeners = new HashMap();

    public AnnotatedMapListenerManager(AnnotatedMapListener.FilterProducer filterProducer, AnnotatedMapListener.MapEventTransformerProducer transformerProducer) {
        this.f_filterProducer = filterProducer;
        this.f_transformerProducer = transformerProducer;
    }

    protected void registerListeners(String sCacheName, String sEventScope, String sEventSession, String sEventService) {
        Set<AnnotatedMapListener<?, ?>> setListeners = this.getMapListeners(this.removeScope(sEventService), sCacheName);
        Session session = (Session)Coherence.findSession((String)sEventSession).orElseThrow(() -> new IllegalStateException("Cannot find a Session with name " + sEventSession));
        NamedCache cache = session.getCache(sCacheName, new NamedMap.Option[0]);
        for (AnnotatedMapListener<?, ?> listener : setListeners) {
            MapEventTransformer transformer;
            boolean fSessionOK;
            String sScope;
            if (listener.hasFilterAnnotation()) {
                listener.resolveFilter(this.f_filterProducer);
            }
            if (listener.hasTransformerAnnotation()) {
                listener.resolveTransformer(this.f_transformerProducer);
            }
            boolean fScopeOK = (sScope = listener.getScopeName()) == null || sScope.equals(sEventScope);
            String sSession = listener.getSessionName();
            boolean bl = fSessionOK = sSession == null || sSession.equals(sEventSession);
            if (!fScopeOK || !fSessionOK) continue;
            MapEventFilter filter = listener.getFilter();
            if (filter != null && !(filter instanceof MapEventFilter)) {
                filter = new MapEventFilter(7, filter);
            }
            if ((transformer = listener.getTransformer()) != null) {
                filter = new MapEventTransformerFilter((Filter)filter, transformer);
            }
            try {
                boolean fLite = listener.isLite();
                if (listener.isSynchronous()) {
                    cache.addMapListener(listener.synchronous(), (Filter)filter, fLite);
                    continue;
                }
                cache.addMapListener(listener, (Filter)filter, fLite);
            }
            catch (Exception e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }
    }

    private String removeScope(String sServiceName) {
        if (sServiceName == null) {
            return "";
        }
        int nIndex = sServiceName.indexOf(58);
        return nIndex > -1 ? sServiceName.substring(nIndex + 1) : sServiceName;
    }

    public void addMapListener(AnnotatedMapListener<?, ?> listener) {
        String svc = listener.getServiceName();
        String cache = listener.getCacheName();
        Map mapByCache = this.m_mapListeners.computeIfAbsent(svc, s -> new HashMap());
        Set setListeners = mapByCache.computeIfAbsent(cache, c -> new HashSet());
        setListeners.add(listener);
    }

    public Set<AnnotatedMapListener<?, ?>> getMapListeners(String serviceName, String cacheName) {
        HashSet setResults = new HashSet();
        this.collectMapListeners(setResults, "*", "*");
        this.collectMapListeners(setResults, "*", cacheName);
        this.collectMapListeners(setResults, serviceName, "*");
        this.collectMapListeners(setResults, serviceName, cacheName);
        return setResults;
    }

    public Collection<AnnotatedMapListener<?, ?>> getNonWildcardMapListeners() {
        return this.m_mapListeners.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(listener -> listener.getSessionName() != null).filter(listener -> !listener.isWildCardCacheName()).sorted().collect(Collectors.toList());
    }

    private void collectMapListeners(HashSet<AnnotatedMapListener<?, ?>> setResults, String serviceName, String cacheName) {
        Map<String, Set<AnnotatedMapListener<?, ?>>> mapByCache = this.m_mapListeners.get(serviceName);
        if (mapByCache != null) {
            setResults.addAll(mapByCache.getOrDefault(cacheName, Collections.emptySet()));
        }
    }
}

