/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.messages.cache.v0.AddIndexRequest;
import com.oracle.coherence.grpc.messages.cache.v0.AggregateRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsEntryRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsKeyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsValueRequest;
import com.oracle.coherence.grpc.messages.cache.v0.Entry;
import com.oracle.coherence.grpc.messages.cache.v0.EntryResult;
import com.oracle.coherence.grpc.messages.cache.v0.EntrySetRequest;
import com.oracle.coherence.grpc.messages.cache.v0.GetAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.GetRequest;
import com.oracle.coherence.grpc.messages.cache.v0.InvokeAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.InvokeRequest;
import com.oracle.coherence.grpc.messages.cache.v0.IsEmptyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.IsReadyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.KeySetRequest;
import com.oracle.coherence.grpc.messages.cache.v0.OptionalValue;
import com.oracle.coherence.grpc.messages.cache.v0.PageRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutIfAbsentRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveIndexRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveMappingRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ReplaceMappingRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ReplaceRequest;
import com.oracle.coherence.grpc.messages.cache.v0.SizeRequest;
import com.oracle.coherence.grpc.messages.cache.v0.TruncateRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ValuesRequest;
import com.oracle.coherence.grpc.proxy.common.v0.BaseNamedCacheServiceImpl;
import com.oracle.coherence.grpc.proxy.common.v0.NamedCacheService;
import com.oracle.coherence.grpc.proxy.common.v0.PagedQueryHelper;
import com.oracle.coherence.grpc.proxy.common.v0.ResponseHandlers;
import com.oracle.coherence.grpc.v0.CacheRequestHolder;
import com.oracle.coherence.grpc.v0.RequestHolder;
import com.tangosol.internal.util.processor.BinaryProcessors;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.grpc.GrpcDependencies;
import com.tangosol.util.Aggregators;
import com.tangosol.util.Binary;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NettyNamedCacheService
extends BaseNamedCacheServiceImpl
implements NamedCacheService {
    public NettyNamedCacheService(NamedCacheService.Dependencies dependencies) {
        super(dependencies);
    }

    public static NettyNamedCacheService newInstance(NamedCacheService.Dependencies deps) {
        return new NettyNamedCacheService(deps);
    }

    public static NettyNamedCacheService newInstance() {
        return NettyNamedCacheService.newInstance((NamedCacheService.Dependencies)new NamedCacheService.DefaultDependencies(GrpcDependencies.ServerType.Asynchronous));
    }

    public void addIndex(AddIndexRequest request, StreamObserver<Empty> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(x$0 -> this.addIndex((CacheRequestHolder)x$0), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void aggregate(AggregateRequest request, StreamObserver<BytesValue> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        ByteString processorBytes = request.getAggregator();
        if (processorBytes.isEmpty()) {
            safeObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized entry aggregator").asRuntimeException());
        } else {
            try {
                if (request.getKeysCount() != 0) {
                    this.aggregateWithKeys(request, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)safeObserver), this.f_executor);
                } else {
                    this.aggregateWithFilter(request, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)safeObserver), this.f_executor);
                }
            }
            catch (Throwable t) {
                safeObserver.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
            }
        }
    }

    public void containsEntry(ContainsEntryRequest request, StreamObserver<BoolValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::containsEntry, this.f_executor).thenApplyAsync(h -> this.toBoolValue((Binary)h.getResult(), h.getCacheSerializer()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<CacheRequestHolder<ContainsEntryRequest, Binary>> containsEntry(CacheRequestHolder<ContainsEntryRequest, Void> holder) {
        ContainsEntryRequest request = (ContainsEntryRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Binary value = holder.convertDown(request.getValue());
        InvocableMap.EntryProcessor processor = this.castProcessor((InvocableMap.EntryProcessor)new BinaryProcessors.BinaryContainsValueProcessor(value));
        return holder.runAsync((CompletionStage)holder.getAsyncCache().invoke((Object)key, processor));
    }

    public void containsKey(ContainsKeyRequest request, StreamObserver<BoolValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::containsKey, this.f_executor).thenApplyAsync(h -> BoolValue.of((boolean)((Boolean)h.getDeserializedResult())), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<CacheRequestHolder<ContainsKeyRequest, Boolean>> containsKey(CacheRequestHolder<ContainsKeyRequest, Void> holder) {
        ContainsKeyRequest request = (ContainsKeyRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        return holder.runAsync((CompletionStage)holder.getAsyncCache().containsKey((Object)key));
    }

    public void containsValue(ContainsValueRequest request, StreamObserver<BoolValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::containsValue, this.f_executor).thenApplyAsync(h -> BoolValue.of(((Integer)h.getResult() > 0 ? 1 : 0) != 0), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<CacheRequestHolder<ContainsValueRequest, Integer>> containsValue(CacheRequestHolder<ContainsValueRequest, Void> holder) {
        ContainsValueRequest request = (ContainsValueRequest)holder.getRequest();
        Object value = BinaryHelper.fromByteString((ByteString)request.getValue(), (Serializer)holder.getSerializer());
        EqualsFilter filter = Filters.equal((ValueExtractor)IdentityExtractor.INSTANCE(), (Object)value);
        return holder.runAsync((CompletionStage)holder.getAsyncCache().aggregate((Filter)filter, (InvocableMap.EntryAggregator)Aggregators.count()));
    }

    public void entrySet(EntrySetRequest request, StreamObserver<Entry> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> this.entrySet((CacheRequestHolder<EntrySetRequest, Void>)h, observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    protected Void entrySet(CacheRequestHolder<EntrySetRequest, Void> holder, StreamObserver<Entry> observer) {
        try {
            EntrySetRequest request = (EntrySetRequest)holder.getRequest();
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Comparator comparator = this.deserializeComparator(request.getComparator(), serializer);
            if (comparator == null) {
                holder.runAsync((CompletionStage)holder.getAsyncCache().entrySet(filter, holder.entryConsumer(observer))).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
            } else {
                holder.runAsync((CompletionStage)holder.getAsyncCache().entrySet(filter, comparator)).handleAsync((h, err) -> ResponseHandlers.handleSetOfEntries((RequestHolder)h, (Throwable)err, (StreamObserver)observer), this.f_executor);
            }
        }
        catch (Throwable t) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
        }
        return VOID;
    }

    public void get(GetRequest request, StreamObserver<OptionalValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::get, this.f_executor).thenApplyAsync(h -> h.toOptionalValue((Binary)h.getDeserializedResult()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<CacheRequestHolder<GetRequest, Binary>> get(CacheRequestHolder<GetRequest, Void> holder) {
        Binary key = holder.convertKeyDown(((GetRequest)holder.getRequest()).getKey());
        InvocableMap.EntryProcessor processor = BinaryProcessors.get();
        return holder.runAsync((CompletionStage)holder.getAsyncCache().invoke((Object)key, processor));
    }

    public void getAll(GetAllRequest request, StreamObserver<Entry> observer) {
        if (request.getKeyList().isEmpty()) {
            observer.onCompleted();
        } else {
            this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> this.getAll((CacheRequestHolder<GetAllRequest, Void>)h, observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
        }
    }

    protected Void getAll(CacheRequestHolder<GetAllRequest, Void> holder, StreamObserver<Entry> observer) {
        Consumer callback = holder.entryConsumer(observer);
        holder.runAsync(this.convertKeys(holder)).thenComposeAsync(h -> h.runAsync((CompletionStage)h.getAsyncCache().invokeAll((Collection)h.getResult(), BinaryProcessors.get(), callback)), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
        return VOID;
    }

    public void invoke(InvokeRequest request, StreamObserver<BytesValue> observer) {
        ByteString processorBytes = request.getProcessor();
        if (!processorBytes.isEmpty()) {
            this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::invoke, this.f_executor).thenApplyAsync(h -> BinaryHelper.toBytesValue((Binary)h.convertUp((Binary)h.getResult())), this.f_executor).handleAsync((result, err) -> {
                ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer));
                return null;
            }, this.f_executor);
        } else {
            observer.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized entry processor").asRuntimeException());
        }
    }

    protected CompletionStage<CacheRequestHolder<InvokeRequest, Binary>> invoke(CacheRequestHolder<InvokeRequest, Void> holder) {
        InvokeRequest request = (InvokeRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)request.getProcessor(), (Serializer)holder.getSerializer());
        return holder.runAsync((CompletionStage)holder.getAsyncCache().invoke((Object)key, processor));
    }

    public void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer) {
        ByteString processorBytes = request.getProcessor();
        if (processorBytes.isEmpty()) {
            observer.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized entry processor").asRuntimeException());
        } else {
            try {
                CompletionStage<Void> future = request.getKeysCount() != 0 ? this.invokeAllWithKeys(request, observer) : this.invokeAllWithFilter(request, observer);
                future.handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
            }
            catch (Throwable t) {
                observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
            }
        }
    }

    protected CompletionStage<Void> invokeAllWithFilter(InvokeAllRequest request, StreamObserver<Entry> observer) {
        return this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> this.invokeAllWithFilter((CacheRequestHolder<InvokeAllRequest, Void>)h, observer), this.f_executor);
    }

    protected CompletionStage<Void> invokeAllWithFilter(CacheRequestHolder<InvokeAllRequest, Void> holder, StreamObserver<Entry> observer) {
        InvokeAllRequest request = (InvokeAllRequest)holder.getRequest();
        ByteString filterBytes = request.getFilter();
        AlwaysFilter filter = filterBytes.isEmpty() ? Filters.always() : (Filter)BinaryHelper.fromByteString((ByteString)filterBytes, (Serializer)holder.getSerializer());
        ByteString processorBytes = request.getProcessor();
        InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)processorBytes, (Serializer)holder.getSerializer());
        Consumer callback = holder.entryConsumer(observer);
        return holder.runAsync((CompletionStage)holder.getAsyncCache().invokeAll((Filter)filter, processor, callback)).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    protected CompletionStage<Void> invokeAllWithKeys(InvokeAllRequest request, StreamObserver<Entry> observer) {
        return this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> this.invokeAllWithKeys((CacheRequestHolder<InvokeAllRequest, Void>)h, observer), this.f_executor);
    }

    protected CompletionStage<Void> invokeAllWithKeys(CacheRequestHolder<InvokeAllRequest, Void> holder, StreamObserver<Entry> observer) {
        InvokeAllRequest request = (InvokeAllRequest)holder.getRequest();
        List keys = request.getKeysList().stream().map(arg_0 -> holder.convertKeyDown(arg_0)).collect(Collectors.toList());
        InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)BinaryHelper.fromByteString((ByteString)request.getProcessor(), (Serializer)holder.getSerializer());
        Consumer callback = holder.entryConsumer(observer);
        return holder.runAsync((CompletionStage)holder.getAsyncCache().invokeAll(keys, processor, callback)).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    public void isEmpty(IsEmptyRequest request, StreamObserver<BoolValue> observer) {
        this.getAsyncCache(request.getScope(), request.getCache()).thenCompose(AsyncNamedMap::isEmpty).thenApplyAsync(BoolValue::of, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    public void isReady(IsReadyRequest request, StreamObserver<BoolValue> observer) {
        this.getAsyncCache(request.getScope(), request.getCache()).thenComposeAsync(c -> CompletableFuture.supplyAsync(() -> c.getNamedMap().isReady()), this.f_executor).thenApplyAsync(BoolValue::of, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    public void keySet(KeySetRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> this.keySet((CacheRequestHolder<KeySetRequest, Void>)h, observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    protected Void keySet(CacheRequestHolder<KeySetRequest, Void> holder, StreamObserver<BytesValue> observer) {
        try {
            KeySetRequest request = (KeySetRequest)holder.getRequest();
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Consumer callback = holder.binaryConsumer(observer);
            holder.runAsync((CompletionStage)holder.getAsyncCache().keySet(filter, callback)).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
        }
        catch (Throwable t) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
        }
        return VOID;
    }

    public void nextKeySetPage(PageRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> PagedQueryHelper.keysPagedQuery((CacheRequestHolder)h, (long)this.getTransferThreshold()), this.f_executor).handleAsync((stream, err) -> ResponseHandlers.handleStream((Stream)stream, (Throwable)err, (StreamObserver)observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    public void nextEntrySetPage(PageRequest request, StreamObserver<EntryResult> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> PagedQueryHelper.entryPagedQuery((CacheRequestHolder)h, (long)this.getTransferThreshold()), this.f_executor).handleAsync((stream, err) -> ResponseHandlers.handleStream((Stream)stream, (Throwable)err, (StreamObserver)observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    public void put(PutRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::put, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<BytesValue> put(CacheRequestHolder<PutRequest, Void> holder) {
        PutRequest request = (PutRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Binary value = holder.convertDown(request.getValue());
        return holder.getAsyncCache().invoke((Object)key, BinaryProcessors.put((Binary)value, (long)request.getTtl())).thenApplyAsync(arg_0 -> holder.deserializeToBytesValue(arg_0), this.f_executor);
    }

    public void putAll(PutAllRequest request, StreamObserver<Empty> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::putAll, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<Empty> putAll(CacheRequestHolder<PutAllRequest, Void> holder) {
        PutAllRequest request = (PutAllRequest)holder.getRequest();
        if (request.getEntryCount() == 0) {
            return CompletableFuture.completedFuture(BinaryHelper.EMPTY);
        }
        HashMap<Binary, Binary> map = new HashMap<Binary, Binary>();
        for (Entry entry : request.getEntryList()) {
            Binary key = holder.convertKeyDown(entry.getKey());
            Binary value = holder.convertDown(entry.getValue());
            map.put(key, value);
        }
        if (holder.getCache().getCacheService() instanceof PartitionedService) {
            return this.partitionedPutAll(holder, map);
        }
        return this.plainPutAll(holder.getAsyncCache(), map, request.getTtl());
    }

    public void putIfAbsent(PutIfAbsentRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::putIfAbsent, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletableFuture<BytesValue> putIfAbsent(CacheRequestHolder<PutIfAbsentRequest, Void> holder) {
        PutIfAbsentRequest request = (PutIfAbsentRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Binary value = holder.convertDown(() -> ((PutIfAbsentRequest)request).getValue());
        return holder.getAsyncCache().invoke((Object)key, BinaryProcessors.putIfAbsent((Binary)value, (long)request.getTtl())).thenApplyAsync(arg_0 -> holder.deserializeToBytesValue(arg_0), this.f_executor);
    }

    public void remove(RemoveRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> h.runAsync(this.remove((CacheRequestHolder<RemoveRequest, Void>)h)), this.f_executor).thenApplyAsync(h -> h.toBytesValue((Binary)h.getResult()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletableFuture<Binary> remove(CacheRequestHolder<RemoveRequest, Void> holder) {
        RemoveRequest request = (RemoveRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        return holder.getAsyncCache().invoke((Object)key, (InvocableMap.EntryProcessor)BinaryProcessors.BinaryRemoveProcessor.INSTANCE).thenApplyAsync(arg_0 -> holder.fromBinary(arg_0), this.f_executor);
    }

    public void removeIndex(RemoveIndexRequest request, StreamObserver<Empty> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(x$0 -> this.removeIndex((CacheRequestHolder)x$0), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    public void removeMapping(RemoveMappingRequest request, StreamObserver<BoolValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(this::removeMapping, this.f_executor).thenApplyAsync(h -> BoolValue.of((boolean)((Boolean)h.getDeserializedResult())), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletionStage<CacheRequestHolder<RemoveMappingRequest, Boolean>> removeMapping(CacheRequestHolder<RemoveMappingRequest, Void> holder) {
        RemoveMappingRequest request = (RemoveMappingRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Object value = BinaryHelper.fromByteString((ByteString)request.getValue(), (Serializer)holder.getSerializer());
        AsyncNamedCache cache = holder.getAsyncCache();
        return holder.runAsync((CompletionStage)cache.remove((Object)key, value));
    }

    public void replace(ReplaceRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> h.runAsync(this.replace((CacheRequestHolder<ReplaceRequest, Void>)h)), this.f_executor).thenApplyAsync(h -> h.toBytesValue((Binary)h.getResult()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletableFuture<Binary> replace(CacheRequestHolder<ReplaceRequest, Void> holder) {
        ReplaceRequest request = (ReplaceRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Binary value = holder.convertDown(request.getValue());
        return holder.getAsyncCache().invoke((Object)key, this.castProcessor((InvocableMap.EntryProcessor)new BinaryProcessors.BinaryReplaceProcessor(value))).thenApplyAsync(arg_0 -> holder.fromBinary(arg_0), this.f_executor);
    }

    public void replaceMapping(ReplaceMappingRequest request, StreamObserver<BoolValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> h.runAsync(this.replaceMapping((CacheRequestHolder<ReplaceMappingRequest, Void>)h)), this.f_executor).thenApplyAsync(h -> this.toBoolValue((Binary)h.getResult(), h.getCacheSerializer()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    protected CompletableFuture<Binary> replaceMapping(CacheRequestHolder<ReplaceMappingRequest, Void> holder) {
        ReplaceMappingRequest request = (ReplaceMappingRequest)holder.getRequest();
        Binary key = holder.convertKeyDown(request.getKey());
        Binary prevValue = holder.convertDown(request.getPreviousValue());
        Binary newValue = holder.convertDown(request.getNewValue());
        return holder.getAsyncCache().invoke((Object)key, this.castProcessor((InvocableMap.EntryProcessor)new BinaryProcessors.BinaryReplaceMappingProcessor(prevValue, newValue)));
    }

    public void size(SizeRequest request, StreamObserver<Int32Value> observer) {
        this.getAsyncCache(request.getScope(), request.getCache()).thenComposeAsync(AsyncNamedMap::size, this.f_executor).thenApplyAsync(Int32Value::of, this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    public void truncate(TruncateRequest request, StreamObserver<Empty> observer) {
        this.getAsyncCache(request.getScope(), request.getCache()).thenApplyAsync(cache -> this.execute(() -> cache.getNamedCache().truncate()), this.f_executor).handleAsync((result, err) -> ResponseHandlers.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)), this.f_executor);
    }

    public void values(ValuesRequest request, StreamObserver<BytesValue> observer) {
        this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenApplyAsync(h -> this.values((CacheRequestHolder<ValuesRequest, Void>)h, observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
    }

    protected Void values(CacheRequestHolder<ValuesRequest, Void> holder, StreamObserver<BytesValue> observer) {
        try {
            ValuesRequest request = (ValuesRequest)holder.getRequest();
            Serializer serializer = holder.getSerializer();
            Filter filter = this.ensureFilter(request.getFilter(), serializer);
            Comparator comparator = this.deserializeComparator(request.getComparator(), serializer);
            AsyncNamedCache cache = holder.getAsyncCache();
            if (comparator == null) {
                Consumer callback = holder.binaryConsumer(observer);
                cache.values(filter, callback).handleAsync((v, err) -> ResponseHandlers.handleErrorOrComplete((Throwable)err, (StreamObserver)observer), this.f_executor);
            } else {
                holder.runAsync((CompletionStage)holder.getAsyncCache().values(filter, comparator)).handleAsync((h, err) -> ResponseHandlers.handleStream((RequestHolder)h, (Throwable)err, (StreamObserver)observer), this.f_executor).handleAsync((v, err) -> ResponseHandlers.handleError((Throwable)err, (StreamObserver)observer), this.f_executor);
            }
        }
        catch (Throwable t) {
            observer.onError((Throwable)ErrorsHelper.ensureStatusRuntimeException((Throwable)t));
        }
        return VOID;
    }

    protected CompletionStage<List<Binary>> convertKeys(CacheRequestHolder<GetAllRequest, Void> holder) {
        return CompletableFuture.supplyAsync(() -> this.convertKeysToBinary(holder), this.f_executor);
    }
}

