/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.base.Logger;
import io.grpc.stub.StreamObserver;

public class LoggingStreamObserver<V>
implements StreamObserver<V> {
    private final StreamObserver<V> f_delegate;
    private final String f_sPrefix;

    public LoggingStreamObserver(StreamObserver<V> delegate, String sPrefix) {
        this.f_delegate = delegate;
        this.f_sPrefix = sPrefix;
    }

    public void onNext(V v) {
        Logger.info((String)("LoggingStreamObserver: " + this.f_sPrefix + " onNext() called message=" + String.valueOf(v)));
        this.f_delegate.onNext(v);
    }

    public void onError(Throwable throwable) {
        Logger.info((String)("LoggingStreamObserver: " + this.f_sPrefix + " onError() called error=" + String.valueOf(throwable)));
        this.f_delegate.onError(throwable);
    }

    public void onCompleted() {
        Logger.info((String)("LoggingStreamObserver: " + this.f_sPrefix + " onCompleted() called"));
        this.f_delegate.onCompleted();
    }
}

