/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.messages.common.v1.CollectionOfInt32;

public class MessageHelper {
    private MessageHelper() {
    }

    public static int[] toIntArray(CollectionOfInt32 col) {
        if (col == null) {
            return new int[0];
        }
        int[] an = new int[col.getValuesCount()];
        for (int i = 0; i < an.length; ++i) {
            an[i] = col.getValues(i);
        }
        return an;
    }

    public static <C extends Iterable<Integer>> CollectionOfInt32 toCollectionOfInt32(C col) {
        CollectionOfInt32.Builder builder = CollectionOfInt32.newBuilder();
        for (Integer i : col) {
            builder.addValues(i);
        }
        return builder.build();
    }

    public static <C extends Iterable<Integer>> CollectionOfInt32 toCollectionOfInt32(int[] an) {
        CollectionOfInt32.Builder builder = CollectionOfInt32.newBuilder();
        for (int i : an) {
            builder.addValues(i);
        }
        return builder.build();
    }

    public static <T extends Message> T unpack(Any any, Class<T> type) {
        if (any == null) {
            return null;
        }
        try {
            return (T)any.unpack(type);
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)("Could not unpack message field of type " + type.getName() + " actual type " + any.getTypeUrl()));
        }
    }
}

