/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.internal;

import com.oracle.coherence.grpc.internal.AbstractGrpcTracingImplementationLoader;
import com.oracle.coherence.grpc.internal.GrpcTracingImplementation;
import com.tangosol.internal.tracing.NoopAware;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.tracing.opentelemetry.OpenTelemetryTracer;
import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;

public class OpenTelemetryGrpcImplementationLoader
extends AbstractGrpcTracingImplementationLoader {
    private static final String CLASS_NAME = "io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry";

    @Override
    protected String getSearchClassName() {
        return CLASS_NAME;
    }

    @Override
    public GrpcTracingImplementation newInstance() {
        return new OpenTelemetryGrpcTracingImplementation();
    }

    protected static OpenTelemetry getOpenTelemetry() {
        Tracer tracer = TracingHelper.getTracer();
        return TracingHelper.isNoop((NoopAware)tracer) || !(tracer instanceof OpenTelemetryTracer) ? null : ((OpenTelemetryTracer)tracer).getOpenTelemetry();
    }

    static class OpenTelemetryGrpcTracingImplementation
    implements GrpcTracingImplementation {
        OpenTelemetryGrpcTracingImplementation() {
        }

        @Override
        public ClientInterceptor createClientInterceptor() {
            OpenTelemetry openTelemetry = OpenTelemetryGrpcImplementationLoader.getOpenTelemetry();
            return openTelemetry == null ? null : GrpcTelemetry.create((OpenTelemetry)openTelemetry).newClientInterceptor();
        }

        @Override
        public ServerInterceptor createServerInterceptor() {
            OpenTelemetry openTelemetry = OpenTelemetryGrpcImplementationLoader.getOpenTelemetry();
            return openTelemetry == null ? null : GrpcTelemetry.create((OpenTelemetry)openTelemetry).newServerInterceptor();
        }
    }
}

