/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hnswlib;

import com.oracle.coherence.hnswlib.Index;
import com.oracle.coherence.hnswlib.QueryTuple;
import com.oracle.coherence.hnswlib.SpaceName;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentIndex
extends Index {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public ConcurrentIndex(SpaceName spaceName, int dimensions) {
        super(spaceName, dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(float[] item, int id, boolean replaceDeleted) {
        this.lock.writeLock().lock();
        try {
            super.addItem(item, id, replaceDeleted);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getLength() {
        this.lock.readLock().lock();
        try {
            int n = super.getLength();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryTuple knnQuery(float[] input, int k) {
        this.lock.readLock().lock();
        try {
            QueryTuple queryTuple = super.knnQuery(input, k);
            return queryTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void save(Path path) {
        this.lock.readLock().lock();
        try {
            super.save(path);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void load(Path path, int maxNumberOfElements) {
        this.lock.writeLock().lock();
        try {
            super.load(path, maxNumberOfElements);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            super.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setEf(int ef) {
        this.lock.writeLock().lock();
        try {
            super.setEf(ef);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean hasId(int id) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.hasId(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void markDeleted(int id) {
        this.lock.writeLock().lock();
        try {
            super.markDeleted(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Optional<float[]> getData(int id) {
        this.lock.readLock().lock();
        try {
            Optional<float[]> optional = super.getData(id);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

