/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import com.oracle.coherence.io.json.genson.BeanView;
import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.EncodingAwareReaderFactory;
import com.oracle.coherence.io.json.genson.Factory;
import com.oracle.coherence.io.json.genson.GenericType;
import com.oracle.coherence.io.json.genson.GensonBuilder;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.ThreadLocalHolder;
import com.oracle.coherence.io.json.genson.reflect.BeanDescriptor;
import com.oracle.coherence.io.json.genson.reflect.BeanDescriptorProvider;
import com.oracle.coherence.io.json.genson.reflect.DefaultTypes;
import com.oracle.coherence.io.json.genson.reflect.RuntimePropertyFilter;
import com.oracle.coherence.io.json.genson.reflect.UnknownPropertyHandler;
import com.oracle.coherence.io.json.genson.stream.JsonReader;
import com.oracle.coherence.io.json.genson.stream.JsonStreamException;
import com.oracle.coherence.io.json.genson.stream.JsonWriter;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public final class Genson {
    private static final Genson _default = new GensonBuilder().create();
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final ConcurrentHashMap<Type, Converter<?>> converterCache = new ConcurrentHashMap();
    private final Factory<Converter<?>> converterFactory;
    private final BeanDescriptorProvider beanDescriptorFactory;
    private final Map<Class<?>, String> classAliasMap;
    private final Map<String, Class<?>> aliasClassMap;
    private final Map<String, String> aliasPackageMap;
    private final Map<String, String> packageAliasMap;
    private final Map<String, String> compatibilityAliasMap;
    private final boolean skipNull;
    private final boolean htmlSafe;
    private final boolean withClassMetadata;
    private final boolean withMetadata;
    private final boolean strictDoubleParse;
    private final boolean indent;
    private final boolean failOnMissingProperty;
    private final boolean enforceTypeAliases;
    private final EncodingAwareReaderFactory readerFactory = new EncodingAwareReaderFactory();
    private final Map<Class<?>, Object> defaultValues;
    private final DefaultTypes defaultTypes;
    private final RuntimePropertyFilter runtimePropertyFilter;
    private final UnknownPropertyHandler unknownPropertyHandler;
    private volatile ClassLoader loader;

    public Genson() {
        this(Genson._default.converterFactory, Genson._default.beanDescriptorFactory, Genson._default.skipNull, Genson._default.htmlSafe, Genson._default.aliasClassMap, Genson._default.aliasPackageMap, Genson._default.compatibilityAliasMap, Genson._default.withClassMetadata, Genson._default.strictDoubleParse, Genson._default.indent, Genson._default.withMetadata, Genson._default.failOnMissingProperty, Genson._default.enforceTypeAliases, Genson._default.defaultValues, Genson._default.defaultTypes, Genson._default.runtimePropertyFilter, Genson._default.unknownPropertyHandler, Genson.class.getClassLoader());
    }

    public Genson(Factory<Converter<?>> converterFactory, BeanDescriptorProvider beanDescProvider, boolean skipNull, boolean htmlSafe, Map<String, Class<?>> classAliases, Map<String, String> packageAliases, Map<String, String> compatibilityAliases, boolean withClassMetadata, boolean strictDoubleParse, boolean indent, boolean withMetadata, boolean failOnMissingProperty, boolean enforceTypeAliases, Map<Class<?>, Object> defaultValues, DefaultTypes defaultTypes, RuntimePropertyFilter runtimePropertyFilter, UnknownPropertyHandler unknownPropertyHandler, ClassLoader classLoader) {
        this.converterFactory = converterFactory;
        this.beanDescriptorFactory = beanDescProvider;
        this.skipNull = skipNull;
        this.htmlSafe = htmlSafe;
        this.enforceTypeAliases = enforceTypeAliases;
        this.aliasClassMap = classAliases;
        this.aliasPackageMap = packageAliases;
        this.withClassMetadata = withClassMetadata;
        this.defaultValues = defaultValues;
        this.defaultTypes = defaultTypes;
        this.runtimePropertyFilter = runtimePropertyFilter;
        this.classAliasMap = new HashMap(this.aliasClassMap.size());
        this.aliasClassMap.forEach((key, value) -> this.classAliasMap.put((Class<?>)value, (String)key));
        this.packageAliasMap = new HashMap<String, String>(this.aliasPackageMap.size());
        this.aliasPackageMap.forEach((key, value) -> this.packageAliasMap.put((String)value, (String)key));
        this.compatibilityAliasMap = compatibilityAliases;
        this.strictDoubleParse = strictDoubleParse;
        this.indent = indent;
        this.withMetadata = withClassMetadata || withMetadata;
        this.failOnMissingProperty = failOnMissingProperty;
        this.unknownPropertyHandler = unknownPropertyHandler;
        this.loader = classLoader;
    }

    public <T> Converter<T> provideConverter(Type forType) {
        if (Boolean.TRUE.equals(ThreadLocalHolder.get("__GENSON$DO_NOT_CACHE_CONVERTER", Boolean.class))) {
            return this.converterFactory.create(forType, this);
        }
        Converter<?> converter = this.converterCache.get(forType);
        if (converter == null) {
            converter = this.converterFactory.create(forType, this);
            if (converter == null) {
                throw new JsonBindingException("No converter found for type " + String.valueOf(forType));
            }
            this.converterCache.putIfAbsent(forType, converter);
        }
        return converter;
    }

    public String serialize(Object object) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, new Context(this));
        }
        return sw.toString();
    }

    public String serialize(Object object, GenericType<?> type) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, type.getType(), writer, new Context(this));
        }
        return sw.toString();
    }

    public String serialize(Object object, Class<? extends BeanView<?>> firstView, Class<? extends BeanView<?>> ... withViews) {
        StringWriter sw = new StringWriter();
        ObjectWriter writer = this.createWriter(sw);
        ArrayList views = new ArrayList(withViews.length);
        for (Class<? extends BeanView<?>> view : withViews) {
            views.add(view);
        }
        views.add(firstView);
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, new Context(this, views));
        }
        return sw.toString();
    }

    public void serialize(Object object, GenericType<?> type, Writer writer) {
        ObjectWriter objectWriter = this.createWriter(writer);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, type.getType(), objectWriter, new Context(this));
        }
    }

    public void serialize(Object object, Writer writer) {
        ObjectWriter objectWriter = this.createWriter(writer);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
    }

    public void serialize(Object object, GenericType<?> type, OutputStream output) {
        ObjectWriter objectWriter = this.createWriter(output);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, type.getType(), objectWriter, new Context(this));
        }
    }

    public void serialize(Object object, OutputStream output) {
        ObjectWriter objectWriter = this.createWriter(output);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
    }

    public byte[] serializeBytes(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectWriter objectWriter = this.createWriter(baos);
        if (object == null) {
            this.serializeNull(objectWriter);
        } else {
            this.serialize(object, object.getClass(), objectWriter, new Context(this));
        }
        return baos.toByteArray();
    }

    public void serialize(Object object, ObjectWriter writer, Context ctx) {
        if (object == null) {
            this.serializeNull(writer);
        } else {
            this.serialize(object, object.getClass(), writer, ctx);
        }
    }

    public void serialize(Object object, Type type, ObjectWriter writer, Context ctx) {
        Converter<Object> ser = this.provideConverter(type);
        try {
            ser.serialize(object, writer, ctx);
            writer.flush();
        }
        catch (Exception e) {
            throw new JsonBindingException("Failed to serialize object of type " + String.valueOf(type), e);
        }
    }

    private void serializeNull(ObjectWriter writer) {
        try {
            writer.writeNull();
            writer.flush();
        }
        catch (Exception e) {
            throw new JsonBindingException("Could not serialize null value.", e);
        }
    }

    public <T> T deserialize(String fromSource, Class<T> toClass) {
        return this.deserialize(GenericType.of(toClass), this.createReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(String fromSource, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(Reader reader, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(reader), new Context(this));
    }

    public <T> T deserialize(Reader reader, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(reader), new Context(this));
    }

    public <T> T deserialize(InputStream input, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(input), new Context(this));
    }

    public <T> T deserialize(InputStream input, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(input), new Context(this));
    }

    public <T> T deserialize(byte[] input, Class<T> toType) {
        return this.deserialize(GenericType.of(toType), this.createReader(input), new Context(this));
    }

    public <T> T deserialize(byte[] input, GenericType<T> toType) {
        return this.deserialize(toType, this.createReader(input), new Context(this));
    }

    public <T> T deserialize(String fromSource, GenericType<T> toType, Class<? extends BeanView<?>> ... withViews) {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(toType, this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(String fromSource, Class<T> toType, Class<? extends BeanView<?>> ... withViews) {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(GenericType.of(toType), this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(GenericType<T> type, Reader reader, Class<? extends BeanView<?>> ... withViews) {
        return this.deserialize(type, this.createReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(GenericType<T> type, ObjectReader reader, Context ctx) {
        Converter<T> deser = this.provideConverter(type.getType());
        try {
            return deser.deserialize(reader, ctx);
        }
        catch (Exception e) {
            throw new JsonBindingException("Could not deserialize to type " + String.valueOf(type.getRawClass()), e);
        }
    }

    public <T> T deserializeInto(String json, T object) {
        return this.deserializeInto(this.createReader(new StringReader(json)), object, new Context(this));
    }

    public <T> T deserializeInto(byte[] jsonBytes, T object) {
        return this.deserializeInto(this.createReader(jsonBytes), object, new Context(this));
    }

    public <T> T deserializeInto(InputStream is, T object) {
        return this.deserializeInto(this.createReader(is), object, new Context(this));
    }

    public <T> T deserializeInto(Reader reader, T object) {
        return this.deserializeInto(this.createReader(reader), object, new Context(this));
    }

    public <T> T deserializeInto(ObjectReader reader, T object, Context ctx) {
        BeanDescriptor<?> bd = this.getBeanDescriptorProvider().provide(object.getClass(), this);
        bd.deserialize(object, reader, ctx);
        return object;
    }

    public <T> Iterator<T> deserializeValues(InputStream is, Class<T> type) {
        return this.deserializeValues(this.createReader(is), GenericType.of(type));
    }

    public <T> Iterator<T> deserializeValues(final ObjectReader reader, final GenericType<T> type) {
        boolean isArray;
        boolean bl = isArray = reader.getValueType() == ValueType.ARRAY;
        if (isArray) {
            reader.beginArray();
        }
        return new Iterator<T>(){
            final Converter<T> converter;
            final Context ctx;
            {
                this.converter = Genson.this.provideConverter(type.getType());
                this.ctx = new Context(Genson.this);
            }

            @Override
            public boolean hasNext() {
                boolean hasMore = reader.hasNext();
                if (isArray && !hasMore) {
                    reader.endArray();
                }
                return hasMore;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                reader.next();
                try {
                    return this.converter.deserialize(reader, this.ctx);
                }
                catch (Exception e) {
                    throw new JsonBindingException("Could not deserialize to type " + String.valueOf(type.getRawClass()), e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public <T> String aliasFor(Class<T> clazz) {
        Object alias = this.classAliasMap.get(clazz);
        if (alias == null) {
            int classNameBoundary;
            String packageName;
            String packageAlias;
            alias = clazz.getName();
            if (((String)alias).charAt(0) == '[') {
                alias = ((String)alias).substring(2, ((String)alias).length() - 1);
            }
            if ((packageAlias = this.packageAliasMap.get(packageName = ((String)alias).substring(0, classNameBoundary = ((String)alias).lastIndexOf(46)))) != null) {
                String className = ((String)alias).substring(classNameBoundary);
                alias = packageAlias + className;
                this.aliasClassMap.put((String)alias, clazz);
            } else if (this.enforceTypeAliases) {
                if (((String)alias).startsWith("java.") || ((String)alias).startsWith("javax.")) {
                    String sOrigName = clazz.getName();
                    this.classAliasMap.put(clazz, sOrigName);
                    this.aliasClassMap.put(sOrigName, clazz);
                    return sOrigName;
                }
                throw new JsonBindingException(String.format("Unable to find type or package alias for %s", clazz.toString()));
            }
            this.classAliasMap.put(clazz, (String)alias);
        }
        return alias;
    }

    public Class<?> classFor(String alias) throws ClassNotFoundException {
        Class<?> clazz = this.aliasClassMap.get(alias);
        if (clazz == null) {
            String sAliasFor = this.compatibilityAliasMap.get(alias);
            if (sAliasFor != null) {
                return this.classFor(sAliasFor);
            }
            int cIdx = ((String)alias).lastIndexOf(46);
            if (cIdx != -1) {
                String packageAlias = ((String)alias).substring(0, cIdx);
                String packageToUse = this.aliasPackageMap.get(packageAlias);
                if (packageToUse != null) {
                    String className = ((String)alias).substring(cIdx);
                    alias = packageToUse + className;
                } else if (this.enforceTypeAliases && !((String)alias).startsWith("java.") && !((String)alias).startsWith("javax.")) {
                    throw new JsonBindingException(String.format("Unable to find matching type or package alias for %s", alias));
                }
            }
            clazz = this.loader != null ? Class.forName((String)alias, true, this.loader) : Class.forName((String)alias);
            this.aliasClassMap.put((String)alias, clazz);
        }
        return clazz;
    }

    public ObjectWriter createWriter(OutputStream os) {
        return new JsonWriter(new OutputStreamWriter(os, UTF8_CHARSET), this.skipNull, this.htmlSafe, this.indent);
    }

    public ObjectWriter createWriter(OutputStream os, Charset charset) {
        return this.createWriter(new OutputStreamWriter(os, charset));
    }

    public ObjectWriter createWriter(Writer writer) {
        return new JsonWriter(writer, this.skipNull, this.htmlSafe, this.indent);
    }

    public ObjectReader createReader(byte[] in) {
        try {
            return this.createReader(this.readerFactory.createReader(new ByteArrayInputStream(in)));
        }
        catch (IOException e) {
            throw new JsonStreamException("Failed to detect encoding.", e);
        }
    }

    public ObjectReader createReader(InputStream is) {
        try {
            return this.createReader(this.readerFactory.createReader(is));
        }
        catch (IOException e) {
            throw new JsonStreamException("Failed to detect encoding.", e);
        }
    }

    public ObjectReader createReader(InputStream is, Charset charset) {
        return this.createReader(new InputStreamReader(is, charset));
    }

    public ObjectReader createReader(Reader reader) {
        return new JsonReader(reader, this.strictDoubleParse, this.withMetadata);
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public boolean isWithClassMetadata() {
        return this.withClassMetadata;
    }

    public BeanDescriptorProvider getBeanDescriptorProvider() {
        return this.beanDescriptorFactory;
    }

    public boolean failOnMissingProperty() {
        return this.failOnMissingProperty;
    }

    public <T> T defaultValue(Class<T> clazz) {
        return (T)this.defaultValues.get(clazz);
    }

    public Class<?> defaultClass(ValueType type) {
        return this.defaultTypes.getClass(type);
    }

    public RuntimePropertyFilter runtimePropertyFilter() {
        return this.runtimePropertyFilter;
    }

    public UnknownPropertyHandler unknownPropertyHandler() {
        return this.unknownPropertyHandler;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Deprecated
    public static class Builder
    extends GensonBuilder {
    }
}

