/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.convert;

import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Factory;
import com.oracle.coherence.io.json.genson.Genson;
import java.lang.reflect.Type;

public abstract class ChainedFactory
implements Factory<Converter<?>> {
    private Factory<? extends Converter<?>> next;

    protected ChainedFactory() {
    }

    protected ChainedFactory(Factory<Converter<?>> next) {
        this.next = next;
    }

    @Override
    public Converter<?> create(Type type, Genson genson) {
        Converter<?> converter;
        Converter<?> nextConverter = null;
        if (this.next != null) {
            nextConverter = this.next.create(type, genson);
        }
        return (converter = this.create(type, genson, nextConverter)) == null ? nextConverter : converter;
    }

    protected abstract Converter<?> create(Type var1, Genson var2, Converter<?> var3);

    public final <T extends Factory<? extends Converter<?>>> T withNext(T next) {
        if (next instanceof ChainedFactory) {
            ((ChainedFactory)next).next = this.next;
        } else if (this.next != null) {
            throw new IllegalStateException("next factory has already been set for " + String.valueOf(this.getClass()) + " you can not override it!");
        }
        this.next = next;
        return next;
    }

    public final <T extends Factory<? extends Converter<?>>> T append(T next) {
        ChainedFactory f = this;
        while (f.next() != null) {
            if (!(f.next() instanceof ChainedFactory)) {
                throw new UnsupportedOperationException("Last element in the chain is not a ChainedFactory");
            }
            f = (ChainedFactory)f.next();
        }
        return f.withNext(next);
    }

    public ChainedFactory find(Class<? extends ChainedFactory> clazz) {
        ChainedFactory f = this;
        while (true) {
            if (f.getClass().equals(clazz)) {
                return f;
            }
            if (!(f.next() instanceof ChainedFactory)) break;
            f = (ChainedFactory)f.next();
        }
        return null;
    }

    public final Factory<? extends Converter<?>> next() {
        return this.next;
    }
}

