/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.autoconfigure.data;

import com.oracle.coherence.spring.data.config.EnableCoherenceRepositories;
import com.oracle.coherence.spring.data.support.CoherenceRepositoryConfigurationExtension;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.springframework.boot.autoconfigure.data.AbstractRepositoryConfigurationSourceSupport;
import org.springframework.core.env.Environment;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.util.StringUtils;

public class CoherenceRepositoriesRegistrar
extends AbstractRepositoryConfigurationSourceSupport {
    private BootstrapMode bootstrapMode = null;

    protected Class<? extends Annotation> getAnnotation() {
        return EnableCoherenceRepositories.class;
    }

    protected Class<?> getConfiguration() {
        return EnableCoherenceRepositoriesConfiguration.class;
    }

    protected RepositoryConfigurationExtension getRepositoryConfigurationExtension() {
        return new CoherenceRepositoryConfigurationExtension();
    }

    protected BootstrapMode getBootstrapMode() {
        return this.bootstrapMode == null ? BootstrapMode.DEFAULT : this.bootstrapMode;
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.configureBootstrapMode(environment);
    }

    private void configureBootstrapMode(Environment environment) {
        String property = environment.getProperty("coherence.spring.data.repositories.bootstrap-mode");
        if (StringUtils.hasText((String)property)) {
            this.bootstrapMode = BootstrapMode.valueOf((String)property.toUpperCase(Locale.ENGLISH));
        }
    }

    @EnableCoherenceRepositories
    private static class EnableCoherenceRepositoriesConfiguration {
        private EnableCoherenceRepositoriesConfiguration() {
        }
    }
}

