/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class CoherenceSpringSessionCondition
extends SpringBootCondition {
    private static final String STORE_TYPE_PROPERTY = "spring.session.store-type";

    CoherenceSpringSessionCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Coherence Session Condition", (Object[])new Object[0]);
        Environment environment = context.getEnvironment();
        if (!environment.containsProperty(STORE_TYPE_PROPERTY)) {
            return ConditionOutcome.match((ConditionMessage)message.didNotFind("property", "properties").items(ConditionMessage.Style.QUOTE, new Object[]{STORE_TYPE_PROPERTY}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.found(String.format("%s property (value: '%s')", STORE_TYPE_PROPERTY, environment.getProperty(STORE_TYPE_PROPERTY))).atAll());
    }
}

