/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigDataResource;
import com.oracle.coherence.spring.boot.config.CoherenceGrpcClient;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class CoherenceConfigDataLoader
implements ConfigDataLoader<CoherenceConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, CoherenceConfigDataResource resource) {
        return new ConfigData(this.getPropertySources(resource), new ConfigData.Option[0]);
    }

    public List<PropertySource<?>> getPropertySources(CoherenceConfigDataResource resource) {
        try (CoherenceGrpcClient coherenceGrpcClient = new CoherenceGrpcClient(resource.getProperties());){
            List<String> keys = this.buildSourceNames(resource);
            ArrayList<MapPropertySource> composite = new ArrayList<MapPropertySource>();
            Session session = coherenceGrpcClient.getCoherenceSession();
            for (String propertySourceName : keys) {
                NamedMap configMap = session.getMap(propertySourceName, new NamedMap.Option[0]);
                HashMap results = new HashMap(configMap);
                MapPropertySource propertySource = new MapPropertySource(propertySourceName, results);
                composite.add(propertySource);
            }
            ArrayList<MapPropertySource> arrayList = composite;
            return arrayList;
        }
    }

    protected List<String> buildSourceNames(CoherenceConfigDataResource coherenceConfigDataResource) {
        Assert.notNull((Object)((Object)coherenceConfigDataResource), (String)"coherenceConfigDataResource must not be null.");
        String configuredApplicationName = coherenceConfigDataResource.getProperties().getApplicationName();
        List<String> profiles = coherenceConfigDataResource.getProfilesAsList();
        ArrayList<String> configKeys = new ArrayList<String>();
        for (String profileName : profiles) {
            configKeys.add(configuredApplicationName + "-" + profileName);
        }
        return configKeys;
    }
}

