/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import com.oracle.coherence.spring.boot.config.CoherenceConfigDataResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.util.StringUtils;

public class CoherenceConfigDataLocationResolver
implements ConfigDataLocationResolver<CoherenceConfigDataResource> {
    protected static final Log logger = LogFactory.getLog(CoherenceConfigDataLocationResolver.class);
    public static final String COHERENCE_PREFIX = "coherence:";

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(this.getPrefix())) {
            return false;
        }
        return (Boolean)context.getBinder().bind("coherence.config-client.enabled", Boolean.class).orElse((Object)true);
    }

    protected String getPrefix() {
        return COHERENCE_PREFIX;
    }

    public List<CoherenceConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return Collections.emptyList();
    }

    public List<CoherenceConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        CoherenceConfigClientProperties properties = this.loadProperties(resolverContext);
        String uris = location.getNonPrefixedValue(this.getPrefix());
        if (StringUtils.hasText((String)uris) && logger.isWarnEnabled()) {
            logger.warn((Object)("Uri values following the prefix '" + this.getPrefix() + "' are not currently supported and are ignored. However, you specified: " + uris));
        }
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        bootstrapContext.registerIfAbsent(CoherenceConfigClientProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        bootstrapContext.addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton("coherenceConfigDataConfigClientProperties", event.getBootstrapContext().get(CoherenceConfigClientProperties.class)));
        ArrayList<CoherenceConfigDataResource> locations = new ArrayList<CoherenceConfigDataResource>(1);
        locations.add(new CoherenceConfigDataResource(properties, location.isOptional(), profiles));
        return locations;
    }

    protected CoherenceConfigClientProperties loadProperties(ConfigDataLocationResolverContext context) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        CoherenceConfigClientProperties configClientProperties = (CoherenceConfigClientProperties)binder.bind("coherence.config-client", Bindable.of(CoherenceConfigClientProperties.class), bindHandler).orElseGet(CoherenceConfigClientProperties::new);
        if (!StringUtils.hasText((String)configClientProperties.getApplicationName())) {
            String applicationName = (String)binder.bind("spring.application.name", Bindable.of(String.class), bindHandler).orElse((Object)"application");
            configClientProperties.setApplicationName(applicationName);
        }
        return configClientProperties;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }
}

