/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class CoherenceConfigDataResource
extends ConfigDataResource {
    private final CoherenceConfigClientProperties properties;
    private final boolean optional;
    private final Profiles profiles;

    public CoherenceConfigDataResource(CoherenceConfigClientProperties properties, boolean optional, Profiles profiles) {
        this.properties = properties;
        this.optional = optional;
        this.profiles = profiles;
    }

    public CoherenceConfigClientProperties getProperties() {
        return this.properties;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        List accepted = this.profiles.getAccepted();
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            return this.properties.getProfile();
        }
        return StringUtils.collectionToCommaDelimitedString((Collection)accepted);
    }

    public List<String> getProfilesAsList() {
        ArrayList<String> profilesToReturn = new ArrayList<String>();
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            profilesToReturn.add(this.properties.getProfile());
        } else {
            List accepted = this.profiles.getAccepted();
            profilesToReturn.addAll(accepted);
        }
        return profilesToReturn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoherenceConfigDataResource that = (CoherenceConfigDataResource)((Object)o);
        return this.optional == that.optional && this.properties.equals(that.properties) && this.profiles.equals(that.profiles);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.optional, this.profiles);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("client", (Object)this.properties.getClient()).append("optional", this.optional).append("profiles", (Object)this.profiles.getAccepted()).toString();
    }
}

