/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.autoconfigure;

import com.oracle.coherence.spring.boot.autoconfigure.support.LogType;
import com.oracle.coherence.spring.configuration.session.AbstractSessionConfigurationBean;
import com.oracle.coherence.spring.configuration.session.ClientSessionConfigurationBean;
import com.oracle.coherence.spring.configuration.session.GrpcSessionConfigurationBean;
import com.oracle.coherence.spring.configuration.session.ServerSessionConfigurationBean;
import com.oracle.coherence.spring.configuration.support.CoherenceInstanceType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="coherence")
public class CoherenceProperties {
    public static final String PREFIX = "coherence";
    private static final String LOG_LIMIT = "coherence.log.limit";
    private static final String LOG_DESTINATION = "coherence.log";
    private static final String LOG_LEVEL = "coherence.log.level";
    private static final String LOG_LOGGER_NAME = "coherence.log.logger";
    private static final String LOG_MESSAGE_FORMAT = "coherence.log.format";
    private Map<String, String> properties = new HashMap<String, String>();
    private LoggingProperties logging;
    private CacheAbstractionProperties cache = new CacheAbstractionProperties();
    private String propertyPrefix = "";
    private ServerProperties server = new ServerProperties();
    private InstanceProperties instance = new InstanceProperties();
    private SessionProperties sessions = new SessionProperties();

    public SessionProperties getSessions() {
        return this.sessions;
    }

    public void setSessions(SessionProperties sessions) {
        this.sessions = sessions;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public LoggingProperties getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingProperties logging) {
        this.logging = logging;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public CacheAbstractionProperties getCache() {
        return this.cache;
    }

    public void setCache(CacheAbstractionProperties cache) {
        this.cache = cache;
    }

    public ServerProperties getServer() {
        return this.server;
    }

    public void setServer(ServerProperties server) {
        this.server = server;
    }

    public InstanceProperties getInstance() {
        return this.instance;
    }

    public void setInstance(InstanceProperties instance) {
        this.instance = instance;
    }

    final Map<String, Object> retrieveCoherencePropertiesAsMap() {
        HashMap<String, Object> coherenceProperties = new HashMap<String, Object>();
        if (this.logging != null) {
            if (this.logging.destination != null) {
                coherenceProperties.put(this.propertyPrefix + LOG_DESTINATION, this.logging.destination.getKey());
            }
            if (StringUtils.hasText((String)this.logging.loggerName)) {
                coherenceProperties.put(this.propertyPrefix + LOG_LOGGER_NAME, this.logging.loggerName);
            }
            if (this.logging.severityLevel != null) {
                coherenceProperties.put(this.propertyPrefix + LOG_LEVEL, this.logging.severityLevel);
            }
            if (StringUtils.hasText((String)this.logging.messageFormat)) {
                coherenceProperties.put(this.propertyPrefix + LOG_MESSAGE_FORMAT, this.logging.messageFormat);
            }
            if (this.logging.characterLimit != null) {
                coherenceProperties.put(this.propertyPrefix + LOG_LIMIT, this.logging.characterLimit);
            }
        }
        return coherenceProperties;
    }

    public static class ServerProperties {
        private Duration startupTimeout;

        public Duration getStartupTimeout() {
            return this.startupTimeout;
        }

        public void setStartupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
        }
    }

    public static class InstanceProperties {
        private CoherenceInstanceType type;

        public CoherenceInstanceType getType() {
            return this.type;
        }

        public void setType(CoherenceInstanceType type) {
            this.type = type;
        }
    }

    public static class CacheAbstractionProperties {
        private Duration timeToLive = Duration.ZERO;
        private boolean useCacheNamePrefix = false;
        private String cacheNamePrefix = "";
        private boolean useLocks = true;
        private boolean lockEntireCache = false;
        private long lockTimeout = 0L;

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public String getCacheNamePrefix() {
            return this.cacheNamePrefix;
        }

        public void setCacheNamePrefix(String cacheNamePrefix) {
            this.cacheNamePrefix = cacheNamePrefix;
        }

        public boolean isUseCacheNamePrefix() {
            return this.useCacheNamePrefix;
        }

        public void setUseCacheNamePrefix(boolean useCacheNamePrefix) {
            this.useCacheNamePrefix = useCacheNamePrefix;
        }

        public boolean isUseLocks() {
            return this.useLocks;
        }

        public void setUseLocks(boolean useLocks) {
            this.useLocks = useLocks;
        }

        public boolean isLockEntireCache() {
            return this.lockEntireCache;
        }

        public void setLockEntireCache(boolean lockEntireCache) {
            this.lockEntireCache = lockEntireCache;
        }

        public long getLockTimeout() {
            return this.lockTimeout;
        }

        public void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }
    }

    public static class SessionProperties {
        private List<GrpcSessionConfigurationBean> grpc;
        private List<ClientSessionConfigurationBean> client;
        private List<ServerSessionConfigurationBean> server;

        public List<GrpcSessionConfigurationBean> getGrpc() {
            return this.grpc;
        }

        public void setGrpc(List<GrpcSessionConfigurationBean> grpc) {
            this.grpc = grpc;
        }

        public List<ClientSessionConfigurationBean> getClient() {
            return this.client;
        }

        public void setClient(List<ClientSessionConfigurationBean> client) {
            this.client = client;
        }

        public List<ServerSessionConfigurationBean> getServer() {
            return this.server;
        }

        public void setServer(List<ServerSessionConfigurationBean> server) {
            this.server = server;
        }

        public List<AbstractSessionConfigurationBean> getAllSessionConfigurationBeans() {
            ArrayList<AbstractSessionConfigurationBean> sessionConfigurationBeans = new ArrayList<AbstractSessionConfigurationBean>();
            if (!CollectionUtils.isEmpty(this.client)) {
                sessionConfigurationBeans.addAll(this.client);
            }
            if (!CollectionUtils.isEmpty(this.server)) {
                sessionConfigurationBeans.addAll(this.server);
            }
            if (!CollectionUtils.isEmpty(this.grpc)) {
                sessionConfigurationBeans.addAll(this.grpc);
            }
            return sessionConfigurationBeans;
        }
    }

    public static class LoggingProperties {
        private LogType destination = LogType.SLF4J;
        private Integer severityLevel;
        private String loggerName;
        private String messageFormat;
        private Integer characterLimit;

        public LogType getDestination() {
            return this.destination;
        }

        public void setDestination(LogType destination) {
            this.destination = destination;
        }

        public Integer getSeverityLevel() {
            return this.severityLevel;
        }

        public void setSeverityLevel(Integer severityLevel) {
            this.severityLevel = severityLevel;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getMessageFormat() {
            return this.messageFormat;
        }

        public void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public Integer getCharacterLimit() {
            return this.characterLimit;
        }

        public void setCharacterLimit(Integer characterLimit) {
            this.characterLimit = characterLimit;
        }
    }
}

