/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.client.GrpcSessionConfiguration;
import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CoherenceGrpcClient
implements AutoCloseable {
    protected static final Log logger = LogFactory.getLog(CoherenceGrpcClient.class);
    private final Session coherenceSession;
    private final ManagedChannel grpcChannel;

    public CoherenceGrpcClient(CoherenceConfigClientProperties coherenceConfigClientProperties) {
        this.grpcChannel = this.buildChannel(coherenceConfigClientProperties);
        this.coherenceSession = this.buildSession((Channel)this.grpcChannel, coherenceConfigClientProperties);
    }

    public Session getCoherenceSession() {
        return this.coherenceSession;
    }

    protected Session buildSession(Channel grpcChannel, CoherenceConfigClientProperties coherenceConfigClientProperties) {
        Assert.notNull((Object)grpcChannel, (String)"grpcChannel must not be null");
        Assert.notNull((Object)coherenceConfigClientProperties, (String)"coherenceConfigClientProperties must not be null");
        GrpcSessionConfiguration.Builder builder = GrpcSessionConfiguration.builder((Channel)grpcChannel);
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getSessionName())) {
            builder.named(coherenceConfigClientProperties.getSessionName());
        }
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getScopeName())) {
            builder.withScopeName(coherenceConfigClientProperties.getScopeName());
        }
        GrpcSessionConfiguration grpcSessionConfiguration = builder.build();
        Optional optional = Session.create((SessionConfiguration)grpcSessionConfiguration);
        return optional.orElseGet(() -> {
            throw new IllegalStateException("Unable to create session.");
        });
    }

    protected ManagedChannel buildChannel(CoherenceConfigClientProperties coherenceConfigClientProperties) {
        Assert.notNull((Object)coherenceConfigClientProperties, (String)"coherenceConfigClientProperties must not be null");
        String host = coherenceConfigClientProperties.getClient().getHost();
        int port = coherenceConfigClientProperties.getClient().getPort();
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)host, (int)port);
        if (!coherenceConfigClientProperties.getClient().isEnableTls()) {
            channelBuilder.usePlaintext();
        }
        return channelBuilder.build();
    }

    @Override
    public void close() {
        this.grpcChannel.shutdownNow();
    }
}

