/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.autoconfigure;

import com.oracle.coherence.spring.CoherenceServer;
import com.oracle.coherence.spring.boot.autoconfigure.CachingEnabledCondition;
import com.oracle.coherence.spring.boot.autoconfigure.CoherenceProperties;
import com.oracle.coherence.spring.boot.autoconfigure.messaging.CoherencePublisherAutoConfigurationScanRegistrar;
import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import com.oracle.coherence.spring.cache.CoherenceCacheConfiguration;
import com.oracle.coherence.spring.cache.CoherenceCacheManager;
import com.oracle.coherence.spring.configuration.DefaultCoherenceConfigurer;
import com.oracle.coherence.spring.configuration.annotation.EnableCoherence;
import com.oracle.coherence.spring.configuration.session.AbstractSessionConfigurationBean;
import com.oracle.coherence.spring.configuration.support.CoherenceConfigurerCustomizer;
import com.oracle.coherence.spring.configuration.support.SpringSystemPropertyResolver;
import com.oracle.coherence.spring.messaging.CoherencePublisherProxyFactoryBean;
import com.tangosol.net.Coherence;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

@AutoConfiguration
@ConditionalOnMissingBean(value={CoherenceServer.class})
@EnableCoherence
@EnableConfigurationProperties(value={CoherenceProperties.class, CoherenceConfigClientProperties.class})
@AutoConfigureBefore(value={CacheAutoConfiguration.class})
public class CoherenceAutoConfiguration {
    @Bean
    @Conditional(value={CachingEnabledCondition.class})
    @ConditionalOnMissingBean(value={CacheManager.class})
    CoherenceCacheManager cacheManager(Coherence coherence, CoherenceProperties coherenceProperties) {
        if (coherenceProperties.getCache() != null) {
            CoherenceProperties.CacheAbstractionProperties cacheProperties = coherenceProperties.getCache();
            CoherenceCacheConfiguration coherenceCacheConfiguration = new CoherenceCacheConfiguration();
            coherenceCacheConfiguration.setCacheNamePrefix(cacheProperties.getCacheNamePrefix());
            coherenceCacheConfiguration.setUseCacheNamePrefix(cacheProperties.isUseCacheNamePrefix());
            coherenceCacheConfiguration.setTimeToLive(cacheProperties.getTimeToLive());
            coherenceCacheConfiguration.setLockEntireCache(cacheProperties.isLockEntireCache());
            coherenceCacheConfiguration.setLockTimeout(cacheProperties.getLockTimeout());
            coherenceCacheConfiguration.setUseLocks(cacheProperties.isUseLocks());
            return new CoherenceCacheManager(coherence, coherenceCacheConfiguration);
        }
        return new CoherenceCacheManager(coherence);
    }

    @Bean
    public static BeanFactoryPostProcessor coherenceAutoConfigurationBeanFactoryPostProcessor(ConfigurableEnvironment environment) {
        return beanFactory -> {
            CoherenceProperties coherenceProperties = (CoherenceProperties)Binder.get((Environment)environment).bindOrCreate("coherence", CoherenceProperties.class);
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("coherence.properties", coherenceProperties.retrieveCoherencePropertiesAsMap()));
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            if (registry.containsBeanDefinition("springSystemPropertyResolver")) {
                registry.removeBeanDefinition("springSystemPropertyResolver");
            }
            registry.registerBeanDefinition("springSystemPropertyResolver", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringSystemPropertyResolver.class).addConstructorArgValue((Object)environment).addConstructorArgValue((Object)coherenceProperties.getPropertyPrefix()).getBeanDefinition());
            List<AbstractSessionConfigurationBean> sessionConfigurationBeans = coherenceProperties.getSessions().getAllSessionConfigurationBeans();
            if (!CollectionUtils.isEmpty(sessionConfigurationBeans)) {
                int count = 1;
                for (AbstractSessionConfigurationBean sessionConfigurationBean : sessionConfigurationBeans) {
                    beanFactory.registerSingleton("sessionConfigurationBean_" + count, (Object)sessionConfigurationBean);
                    ++count;
                }
            }
        };
    }

    @Bean
    public CoherenceConfigurerCustomizer<DefaultCoherenceConfigurer> coherenceConfigurerCustomizer(CoherenceProperties coherenceProperties) {
        return configurer -> {
            if (coherenceProperties.getInstance() != null && coherenceProperties.getInstance().getType() != null) {
                configurer.setCoherenceInstanceType(coherenceProperties.getInstance().getType());
            }
            if (coherenceProperties.getServer() != null && coherenceProperties.getServer().getStartupTimeout() != null) {
                configurer.setCoherenceServerStartupTimeout(coherenceProperties.getServer().getStartupTimeout());
            }
        };
    }

    @AutoConfiguration
    @ConditionalOnMissingBean(value={CoherencePublisherProxyFactoryBean.class})
    @Import(value={CoherencePublisherAutoConfigurationScanRegistrar.class})
    public static class CoherencePublisherScanRegistrarConfiguration {
    }
}

