/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.autoconfigure.session;

import com.oracle.coherence.spring.boot.autoconfigure.CoherenceAutoConfiguration;
import com.oracle.coherence.spring.boot.autoconfigure.session.CoherenceSpringSessionCondition;
import com.oracle.coherence.spring.boot.autoconfigure.session.CoherenceSpringSessionProperties;
import com.oracle.coherence.spring.session.CoherenceIndexedSessionRepository;
import com.oracle.coherence.spring.session.config.annotation.web.http.CoherenceHttpSessionConfiguration;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.session.SessionRepository;

@AutoConfigureAfter(value={CoherenceAutoConfiguration.class})
@AutoConfiguration
@EnableConfigurationProperties(value={CoherenceSpringSessionProperties.class})
@Conditional(value={CoherenceSpringSessionCondition.class})
@ConditionalOnClass(value={CoherenceIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnProperty(name={"coherence.spring.session.enabled"}, havingValue="true", matchIfMissing=true)
public class CoherenceSpringSessionAutoConfiguration {

    @AutoConfiguration
    @AutoConfigureBefore(name={"org.springframework.boot.actuate.autoconfigure.session.SessionsEndpointAutoConfiguration"})
    public static class SpringBootCoherenceHttpSessionConfiguration
    extends CoherenceHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties, CoherenceSpringSessionProperties coherenceSpringSessionProperties, ServerProperties serverProperties) {
            Duration timeout = sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout());
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds((int)timeout.getSeconds());
            }
            this.setSessionMapName(coherenceSpringSessionProperties.getMapName());
            this.setFlushMode(coherenceSpringSessionProperties.getFlushMode());
            this.setSaveMode(coherenceSpringSessionProperties.getSaveMode());
            this.setUseEntryProcessor(coherenceSpringSessionProperties.getUseEntryProcessor());
        }
    }
}

