/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigDataResource;
import com.oracle.coherence.spring.boot.config.CoherenceGrpcClient;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class CoherenceConfigDataLoader
implements ConfigDataLoader<CoherenceConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, CoherenceConfigDataResource resource) {
        return new ConfigData(this.getPropertySources(resource), new ConfigData.Option[0]);
    }

    public List<PropertySource<?>> getPropertySources(CoherenceConfigDataResource resource) {
        CoherenceGrpcClient coherenceGrpcClient = new CoherenceGrpcClient(resource.getProperties());
        try {
            List<String> keys = this.buildSourceNames(resource);
            Session session = coherenceGrpcClient.getCoherenceSession();
            List<PropertySource<?>> list = keys.stream().map(propertySourceName -> new MapPropertySource(propertySourceName, new HashMap(session.getMap(propertySourceName, new NamedMap.Option[0])))).collect(Collectors.toList());
            coherenceGrpcClient.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    coherenceGrpcClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected List<String> buildSourceNames(CoherenceConfigDataResource coherenceConfigDataResource) {
        Assert.notNull((Object)((Object)coherenceConfigDataResource), (String)"coherenceConfigDataResource must not be null.");
        String configuredApplicationName = coherenceConfigDataResource.getProperties().getApplicationName();
        List<String> profiles = coherenceConfigDataResource.getProfilesAsList();
        return profiles.stream().map(profileName -> configuredApplicationName + "-" + profileName).collect(Collectors.toList());
    }
}

