/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import com.oracle.coherence.spring.configuration.annotation.EnableCoherence;
import com.oracle.coherence.spring.configuration.session.SessionConfigurationBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class CoherenceConfigDataResource
extends ConfigDataResource {
    private final CoherenceConfigClientProperties properties;
    private final Profiles profiles;

    public CoherenceConfigDataResource(CoherenceConfigClientProperties properties, boolean optional, Profiles profiles) {
        super(optional);
        this.properties = properties;
        this.profiles = profiles;
    }

    public CoherenceConfigClientProperties getProperties() {
        return this.properties;
    }

    public String getProfiles() {
        List accepted = this.profiles.getAccepted();
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            return this.properties.getProfile();
        }
        return StringUtils.collectionToCommaDelimitedString((Collection)accepted);
    }

    public List<String> getProfilesAsList() {
        ArrayList<String> profilesToReturn = new ArrayList<String>();
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            profilesToReturn.add(this.properties.getProfile());
        } else {
            List accepted = this.profiles.getAccepted();
            profilesToReturn.addAll(accepted);
        }
        return profilesToReturn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoherenceConfigDataResource that = (CoherenceConfigDataResource)((Object)o);
        return this.properties.equals(that.properties) && this.profiles.equals(that.profiles);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.profiles);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("sessionName", (Object)this.properties.getSessionName()).append("cacheConfig", (Object)this.properties.getCacheConfig()).append("profiles", (Object)this.profiles.getAccepted()).toString();
    }

    @Configuration
    @EnableCoherence
    static class CoherenceConfig {
        CoherenceConfig() {
        }

        @Bean
        SessionConfigurationBean sessionConfigurationBean() {
            SessionConfigurationBean sessionConfigurationBean = new SessionConfigurationBean();
            sessionConfigurationBean.setName("");
            return sessionConfigurationBean;
        }
    }
}

