/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.boot.config;

import com.oracle.coherence.spring.boot.config.CoherenceConfigClientProperties;
import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CoherenceGrpcClient
implements AutoCloseable {
    protected static final Log logger = LogFactory.getLog(CoherenceGrpcClient.class);
    private final Session coherenceSession;
    private Coherence coherence;

    public CoherenceGrpcClient(CoherenceConfigClientProperties coherenceConfigClientProperties) {
        this.coherenceSession = this.buildSession(coherenceConfigClientProperties);
    }

    public Session getCoherenceSession() {
        return this.coherenceSession;
    }

    protected Session buildSession(CoherenceConfigClientProperties coherenceConfigClientProperties) {
        Assert.notNull((Object)coherenceConfigClientProperties, (String)"coherenceConfigClientProperties must not be null");
        SessionConfiguration.Builder builder = SessionConfiguration.builder();
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getCacheConfig())) {
            builder.withConfigUri(coherenceConfigClientProperties.getCacheConfig());
        }
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getSessionName())) {
            builder.named(coherenceConfigClientProperties.getSessionName());
        }
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getScopeName())) {
            builder.withScopeName(coherenceConfigClientProperties.getScopeName());
        }
        SessionConfiguration grpcSessionConfiguration = builder.build();
        CoherenceConfiguration cfg = CoherenceConfiguration.builder().withSession(grpcSessionConfiguration).build();
        this.coherence = Coherence.client((CoherenceConfiguration)cfg);
        this.coherence.start().join();
        if (StringUtils.hasText((String)coherenceConfigClientProperties.getSessionName())) {
            return this.coherence.getSession(coherenceConfigClientProperties.getSessionName());
        }
        return this.coherence.getSession();
    }

    @Override
    public void close() {
        if (this.coherence != null) {
            this.coherence.close();
        }
    }
}

