/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.repository;

import com.oracle.coherence.repository.AbstractAsyncRepository;
import com.oracle.coherence.spring.data.core.mapping.CoherencePersistentEntity;
import com.oracle.coherence.spring.data.core.mapping.CoherencePersistentProperty;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.mapping.context.MappingContext;

public class BackingAsyncRepository<T, ID>
extends AbstractAsyncRepository<ID, T> {
    private final AsyncNamedMap<ID, T> namedMap;
    private final MappingContext<CoherencePersistentEntity<T>, CoherencePersistentProperty> mappingContext;
    private final Class<? extends T> domainType;

    public BackingAsyncRepository(NamedMap<ID, T> namedMap, MappingContext<CoherencePersistentEntity<T>, CoherencePersistentProperty> mappingContext, Class<? extends T> domainType) {
        this.namedMap = namedMap.async(new AsyncNamedMap.Option[0]);
        this.mappingContext = mappingContext;
        this.domainType = domainType;
    }

    protected ID getId(T t) {
        CoherencePersistentEntity entity = (CoherencePersistentEntity)this.mappingContext.getPersistentEntity(this.domainType);
        if (entity == null) {
            throw new IllegalStateException("Unable to obtain PersistentEntity for type " + this.domainType.getName());
        }
        CoherencePersistentProperty idProp = (CoherencePersistentProperty)entity.getRequiredIdProperty();
        try {
            return (ID)(idProp.usePropertyAccess() ? Objects.requireNonNull(idProp.getGetter()).invoke(t, new Object[0]) : Objects.requireNonNull(idProp.getField()).get(t));
        }
        catch (Exception ex) {
            throw Base.ensureRuntimeException((Throwable)ex);
        }
    }

    protected Class<? extends T> getEntityType() {
        return this.domainType;
    }

    public AsyncNamedMap<ID, T> getMap() {
        return this.namedMap;
    }

    public CompletableFuture<Long> count() {
        return this.namedMap.size().thenApply(Integer::longValue);
    }

    public CompletableFuture<Void> delete(T entity) {
        return this.remove(entity).thenApply(unused -> null);
    }

    public CompletableFuture<Void> deleteById(ID id) {
        return this.removeById(id).thenApply(unused -> null);
    }

    public CompletableFuture<Boolean> deleteAll(Iterable<? extends T> entities) {
        return this.removeAll(StreamSupport.stream(entities.spliterator(), false));
    }

    public <S extends T> CompletableFuture<Iterable<S>> saveAll(Iterable<S> entities) {
        return this.saveAll(StreamSupport.stream(entities.spliterator(), false)).thenApply(unused -> entities);
    }

    public CompletableFuture<Optional<T>> findById(ID id) {
        return this.get(id).thenApply(Optional::ofNullable);
    }

    public CompletableFuture<Iterable<T>> findAll() {
        return this.getAll().thenApply(ts -> ts);
    }

    public CompletableFuture<Iterable<T>> findAllById(Iterable<ID> ids) {
        return this.getAll((Filter)new InKeySetFilter(Filters.always(), StreamSupport.stream(ids.spliterator(), false).collect(Collectors.toSet()))).thenApply(ts -> ts);
    }

    public CompletableFuture<Boolean> existsById(ID id) {
        return this.getMap().containsKey(id);
    }

    public CompletableFuture<Void> deleteAll() {
        return this.getMap().clear();
    }

    public CompletableFuture<T> delete(T entity, boolean fReturn) {
        return this.remove(entity, fReturn);
    }

    public CompletableFuture<Void> deleteAllById(Iterable<? extends ID> ids) {
        return this.removeAllById(StreamSupport.stream(ids.spliterator(), false).collect(Collectors.toList())).thenApply(unused -> null);
    }

    public CompletableFuture<Boolean> deleteAllById(Collection<? extends ID> colIds) {
        return this.removeAllById(colIds);
    }

    public CompletableFuture<Map<ID, T>> deleteAllById(Collection<? extends ID> colIds, boolean fReturn) {
        return this.removeAllById(colIds, fReturn);
    }

    public CompletableFuture<Boolean> deleteAll(Collection<? extends T> colEntities) {
        return this.removeAll(colEntities);
    }

    public CompletableFuture<Map<ID, T>> deleteAll(Collection<? extends T> colEntities, boolean fReturn) {
        return this.removeAll(colEntities, fReturn);
    }

    public CompletableFuture<Boolean> deleteAll(Stream<? extends T> strEntities) {
        return this.removeAll(strEntities);
    }

    public CompletableFuture<Map<ID, T>> deleteAll(Stream<? extends T> strEntities, boolean fReturn) {
        return this.removeAll(strEntities, fReturn);
    }

    public CompletableFuture<Boolean> deleteAll(Filter<?> filter) {
        return this.removeAll(filter);
    }

    public CompletableFuture<Map<ID, T>> deleteAll(Filter<?> filter, boolean fReturn) {
        return this.removeAll(filter, fReturn);
    }
}

