/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.repository;

import com.oracle.coherence.repository.AbstractRepository;
import com.oracle.coherence.spring.data.core.mapping.CoherencePersistentEntity;
import com.oracle.coherence.spring.data.core.mapping.CoherencePersistentProperty;
import com.oracle.coherence.spring.data.support.Utils;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.LimitFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;

public class BackingRepository<T, ID>
extends AbstractRepository<ID, T> {
    private final NamedMap<ID, T> namedMap;
    private final MappingContext<CoherencePersistentEntity<T>, CoherencePersistentProperty> mappingContext;
    private final Class<? extends T> domainType;

    public BackingRepository(NamedMap<ID, T> namedMap, MappingContext<CoherencePersistentEntity<T>, CoherencePersistentProperty> mappingContext, Class<? extends T> domainType) {
        this.namedMap = namedMap;
        this.mappingContext = mappingContext;
        this.domainType = domainType;
    }

    public NamedMap<ID, T> getMap() {
        return this.namedMap;
    }

    protected ID getId(T t) {
        CoherencePersistentEntity entity = (CoherencePersistentEntity)this.mappingContext.getPersistentEntity(this.domainType);
        if (entity == null) {
            throw new IllegalStateException("Unable to obtain PersistentEntity for type " + this.domainType.getName());
        }
        CoherencePersistentProperty idProp = (CoherencePersistentProperty)entity.getRequiredIdProperty();
        try {
            return (ID)(idProp.usePropertyAccess() ? Objects.requireNonNull(idProp.getGetter()).invoke(t, new Object[0]) : Objects.requireNonNull(idProp.getField()).get(t));
        }
        catch (Exception ex) {
            throw Base.ensureRuntimeException((Throwable)ex);
        }
    }

    protected Class<? extends T> getEntityType() {
        return this.domainType;
    }

    public void delete(T entity) {
        this.remove(entity);
    }

    public void deleteById(ID id) {
        this.removeById(id, false);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.removeAll(StreamSupport.stream(entities.spliterator(), false));
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        this.saveAll(StreamSupport.stream(entities.spliterator(), false));
        return entities;
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.get(id));
    }

    public Iterable<T> findAll() {
        return this.getAll();
    }

    public Iterable<T> findAll(Sort sort) {
        return this.getAllOrderedBy(Filters.always(), Utils.toComparator(sort));
    }

    public Page<T> findAll(Pageable pageable) {
        LimitFilter filter = Utils.configureLimitFilter(pageable, Filters.always());
        return new PageImpl(new ArrayList(this.getAll((Filter)(filter != null ? filter : Filters.always()))), pageable, this.count());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.getAll((Filter)new InKeySetFilter(Filters.always(), StreamSupport.stream(ids.spliterator(), false).collect(Collectors.toSet())));
    }

    public boolean existsById(ID id) {
        return this.getMap().containsKey(id);
    }

    public void deleteAll() {
        this.getMap().truncate();
    }

    public T delete(T entity, boolean fReturn) {
        return (T)this.remove(entity, fReturn);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        this.removeAllById(StreamSupport.stream(ids.spliterator(), false).collect(Collectors.toList()));
    }

    public boolean deleteAllById(Collection<? extends ID> colIds) {
        return this.removeAllById(colIds);
    }

    public Map<ID, T> deleteAllById(Collection<? extends ID> colIds, boolean fReturn) {
        return this.removeAllById(colIds, fReturn);
    }

    public boolean deleteAll(Collection<? extends T> colEntities) {
        return this.removeAll(colEntities);
    }

    public Map<ID, T> deleteAll(Collection<? extends T> colEntities, boolean fReturn) {
        return this.removeAll(colEntities, fReturn);
    }

    public boolean deleteAll(Stream<? extends T> strEntities) {
        return this.removeAll(strEntities);
    }

    public Map<ID, T> deleteAll(Stream<? extends T> strEntities, boolean fReturn) {
        return this.removeAll(strEntities, fReturn);
    }

    public boolean deleteAll(Filter<?> filter) {
        return this.removeAll(filter);
    }

    public Map<ID, T> deleteAll(Filter<?> filter, boolean fReturn) {
        return this.removeAll(filter, fReturn);
    }
}

