/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.repository.query;

import com.oracle.coherence.spring.data.repository.query.QueryResult;
import com.oracle.coherence.spring.data.repository.query.QueryState;
import com.tangosol.util.Aggregators;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

public class CoherenceQueryCreator
extends AbstractQueryCreator<QueryResult, QueryState> {
    private static final char WILDCARD = '%';
    private final QueryState criteria = new QueryState();
    private final PartTree partTree;

    public CoherenceQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.partTree = tree;
    }

    protected QueryState create(Part part, Iterator<Object> iterator) {
        Objects.requireNonNull(part, "part must not be null");
        Objects.requireNonNull(iterator, "iterator must not be null");
        String prop = part.getProperty().toDotPath();
        boolean ignoreCase = this.isIgnoreCase(part);
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                return this.setFilter(ignoreCase ? Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)iterator.next().toString(), (boolean)true) : Filters.equal((String)prop, (Object)iterator.next()));
            }
            case BETWEEN: {
                return this.setFilter(Filters.between((ValueExtractor)Extractors.extract((String)prop), (Comparable)((Comparable)iterator.next()), (Comparable)((Comparable)iterator.next())));
            }
            case IS_NOT_NULL: 
            case EXISTS: {
                return this.setFilter(Filters.isNotNull((ValueExtractor)Extractors.extract((String)prop)));
            }
            case IS_NULL: {
                return this.setFilter(Filters.isNull((ValueExtractor)Extractors.extract((String)prop)));
            }
            case LESS_THAN: 
            case BEFORE: {
                return this.setFilter(Filters.less((ValueExtractor)Extractors.extract((String)prop), (Comparable)((Comparable)iterator.next())));
            }
            case LESS_THAN_EQUAL: {
                return this.setFilter(Filters.lessEqual((ValueExtractor)Extractors.extract((String)prop), (Comparable)((Comparable)iterator.next())));
            }
            case GREATER_THAN: 
            case AFTER: {
                return this.setFilter(Filters.greater((ValueExtractor)Extractors.extract((String)prop), (Comparable)((Comparable)iterator.next())));
            }
            case GREATER_THAN_EQUAL: {
                return this.setFilter(Filters.greaterEqual((ValueExtractor)Extractors.extract((String)prop), (Comparable)((Comparable)iterator.next())));
            }
            case NOT_LIKE: {
                return this.setFilter(Filters.not((Filter)Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)iterator.next().toString(), (boolean)ignoreCase)));
            }
            case LIKE: {
                return this.setFilter(Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)iterator.next().toString(), (boolean)ignoreCase));
            }
            case STARTING_WITH: {
                return this.setFilter(Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)(iterator.next().toString() + '%'), (boolean)ignoreCase));
            }
            case ENDING_WITH: {
                return this.setFilter(Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)('%' + iterator.next().toString()), (boolean)ignoreCase));
            }
            case IS_NOT_EMPTY: {
                return this.setFilter(Filters.isFalse((ValueExtractor)Extractors.chained((String[])new String[]{prop, "isEmpty()"})));
            }
            case IS_EMPTY: {
                return this.setFilter(Filters.isTrue((ValueExtractor)Extractors.chained((String[])new String[]{prop, "isEmpty()"})));
            }
            case NOT_CONTAINING: {
                return this.setFilter(Filters.not((Filter)Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)('%' + iterator.next().toString() + '%'))));
            }
            case CONTAINING: {
                return this.setFilter(Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)('%' + iterator.next().toString() + '%')));
            }
            case NOT_IN: {
                return this.setFilter(Filters.not((Filter)Filters.in((ValueExtractor)Extractors.extract((String)prop), new HashSet((Collection)iterator.next()))));
            }
            case IN: {
                return this.setFilter(Filters.in((ValueExtractor)Extractors.extract((String)prop), new HashSet((Collection)iterator.next())));
            }
            case NEAR: 
            case WITHIN: {
                throw new UnsupportedOperationException("Unsupported keyword: " + part.getType());
            }
            case REGEX: {
                return this.setFilter(Filters.regex((ValueExtractor)Extractors.extract((String)prop), (String)iterator.next().toString()));
            }
            case TRUE: {
                return this.setFilter(Filters.isTrue((ValueExtractor)Extractors.extract((String)prop)));
            }
            case FALSE: {
                return this.setFilter(Filters.isFalse((ValueExtractor)Extractors.extract((String)prop)));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return this.setFilter(Filters.not((Filter)(ignoreCase ? Filters.like((ValueExtractor)Extractors.extract((String)prop), (String)iterator.next().toString(), (boolean)true) : Filters.equal((String)prop, (Object)iterator.next()))));
            }
        }
        return this.criteria;
    }

    private boolean isIgnoreCase(Part part) {
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: 
            case WHEN_POSSIBLE: {
                return true;
            }
        }
        return false;
    }

    private QueryState setFilter(Filter filter) {
        Objects.requireNonNull(filter, "filter must not be null");
        return this.criteria.setFilter(filter);
    }

    protected QueryState and(Part part, @Nullable QueryState base, Iterator<Object> iterator) {
        this.create(part, (Iterator)iterator);
        return this.criteria.and();
    }

    protected QueryState or(QueryState base, QueryState criteria) {
        return this.criteria.or();
    }

    protected QueryResult complete(QueryState criteria, Sort sort) {
        if (this.partTree.hasPredicate()) {
            if (this.partTree.isCountProjection()) {
                this.criteria.setAggregator((InvocableMap.EntryAggregator)Aggregators.count());
            } else if (this.partTree.isDistinct()) {
                this.criteria.setAggregator((InvocableMap.EntryAggregator)Aggregators.distinctValues());
            } else if (this.partTree.isLimiting()) {
                Integer limit = this.partTree.getMaxResults();
                assert (limit != null);
                criteria.setFilter((Filter)criteria.getFilter().asLimitFilter(limit.intValue()));
            }
        }
        return new QueryResult(criteria, sort);
    }
}

