/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.support;

import com.oracle.coherence.spring.data.core.mapping.CoherenceMappingContext;
import com.oracle.coherence.spring.data.core.mapping.CoherencePersistentEntity;
import com.oracle.coherence.spring.data.repository.AsyncCrudRepository;
import com.oracle.coherence.spring.data.repository.BackingAsyncRepository;
import com.oracle.coherence.spring.data.repository.BackingRepository;
import com.oracle.coherence.spring.data.repository.CoherenceAsyncRepository;
import com.oracle.coherence.spring.data.repository.query.CoherenceRepositoryQuery;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;

public class CoherenceRepositoryFactory
extends RepositoryFactorySupport {
    private final Coherence coherence;
    private final CoherenceMappingContext mappingContext;
    private final String sessionName;
    private final String mapName;
    private Session session;
    private NamedMap namedMap;

    public CoherenceRepositoryFactory(Coherence coherence, CoherenceMappingContext mappingContext, String sessionName, String mapName) {
        this.coherence = coherence;
        this.mappingContext = mappingContext;
        this.sessionName = sessionName;
        this.mapName = mapName;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CoherencePersistentEntity entity = (CoherencePersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation((PersistentEntity)entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        Class repositoryInterface = metadata.getRepositoryInterface();
        if (CoherenceAsyncRepository.class.isAssignableFrom(repositoryInterface) || AsyncCrudRepository.class.isAssignableFrom(repositoryInterface)) {
            return new BackingAsyncRepository(this.ensureNamedMap(), this.mappingContext, metadata.getDomainType());
        }
        return new BackingRepository(this.ensureNamedMap(), this.mappingContext, metadata.getDomainType());
    }

    private Session ensureSession() {
        if (this.session == null) {
            this.session = this.coherence.getSession(this.sessionName);
        }
        if (this.session == null) {
            throw new IllegalStateException("Unable to obtain Coherence Session.  Verify a Coherence cluster is available.");
        }
        return this.session;
    }

    private NamedMap ensureNamedMap() {
        if (this.namedMap == null) {
            Session session = this.ensureSession();
            this.namedMap = session.getMap(this.mapName, new NamedMap.Option[0]);
        }
        return this.namedMap;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return BackingRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new CoherenceLookupStrategy(evaluationContextProvider));
    }

    private final class CoherenceLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        private CoherenceLookupStrategy(QueryMethodEvaluationContextProvider evalContextProvider) {
            this.evaluationContextProvider = evalContextProvider;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return new CoherenceRepositoryQuery(CoherenceRepositoryFactory.this.ensureNamedMap(), method, metadata, factory);
        }
    }
}

