/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.support;

import com.oracle.coherence.spring.data.config.CoherenceMap;
import com.oracle.coherence.spring.data.core.mapping.CoherenceMappingContext;
import com.oracle.coherence.spring.data.support.CoherenceRepositoryFactory;
import com.tangosol.net.Coherence;
import java.io.Serializable;
import java.util.Locale;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CoherenceRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private Coherence coherence;
    private final CoherenceMappingContext coherenceMappingContext = new CoherenceMappingContext();

    public CoherenceRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
        this.setMappingContext((MappingContext)this.coherenceMappingContext);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        String mapName;
        Class repoClass = this.getObjectType();
        String sessionName = "";
        if (repoClass.isAnnotationPresent(CoherenceMap.class)) {
            CoherenceMap repository = repoClass.getAnnotation(CoherenceMap.class);
            mapName = repository.value();
            sessionName = repository.session();
        } else {
            String repoClassName = repoClass.getSimpleName();
            int idx = repoClassName.lastIndexOf("Repository");
            if (idx != -1) {
                mapName = repoClassName.substring(0, idx).toLowerCase(Locale.ROOT);
            } else {
                throw new IllegalStateException(String.format("Unable to determine which NamedMap to use.  Please annotate the Repository interface, %s, with com.coherence.spring.data.config.CoherenceMap and specify the name and/or session the repository should use.", repoClass.getName()));
            }
        }
        return new CoherenceRepositoryFactory(this.coherence, this.coherenceMappingContext, sessionName, mapName);
    }

    public void setCoherence(Coherence coherence) {
        this.coherence = coherence;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)(this.coherence != null ? 1 : 0), (String)"Coherence must not be null.");
    }
}

