/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.support;

import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.function.Remote;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Utils {
    @Nullable
    public static <T> Remote.Comparator<? super T> toComparator(@NonNull Sort sort) {
        Remote.Comparator comparator = null;
        if (sort.isSorted()) {
            for (Sort.Order order : sort) {
                if (comparator == null) {
                    comparator = Remote.comparator((ValueExtractor)new UniversalExtractor(order.getProperty()));
                    if (!order.isDescending()) continue;
                    comparator = comparator.reversed();
                    continue;
                }
                Remote.Comparator temp = Remote.comparator((ValueExtractor)new UniversalExtractor(order.getProperty()));
                if (order.isDescending()) {
                    temp = comparator.reversed();
                }
                comparator.thenComparing(temp);
            }
        }
        return comparator;
    }

    @Nullable
    public static LimitFilter configureLimitFilter(Pageable pageable, Filter filter) {
        if (!pageable.isPaged()) {
            return null;
        }
        LimitFilter limitFilter = filter.asLimitFilter(pageable.getPageSize());
        limitFilter.setPage(pageable.getPageNumber());
        return limitFilter;
    }
}

