/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.data.repository.query;

import com.oracle.coherence.spring.data.repository.query.CoherenceQueryCreator;
import com.oracle.coherence.spring.data.repository.query.QueryResult;
import com.oracle.coherence.spring.data.support.Utils;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Aggregators;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filter;
import com.tangosol.util.Fragment;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Processors;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.function.Remote;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.DefaultParameters;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class CoherenceRepositoryQuery
implements RepositoryQuery {
    private final NamedMap namedMap;
    private final Method method;
    private final RepositoryMetadata metadata;
    private final ProjectionFactory factory;
    private final QueryMethod queryMethod;

    public CoherenceRepositoryQuery(NamedMap namedMap, Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        this.namedMap = namedMap;
        this.method = method;
        this.metadata = metadata;
        this.factory = factory;
        this.queryMethod = new QueryMethod(method, metadata, factory);
    }

    public Object execute(Object[] parameters) {
        Collection result;
        PartTree partTree = new PartTree(this.method.getName(), this.metadata.getDomainType());
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)new DefaultParameters(this.method), parameters);
        CoherenceQueryCreator creator = new CoherenceQueryCreator(partTree, (ParameterAccessor)accessor);
        QueryResult queryResult = (QueryResult)creator.createQuery();
        Filter filter = queryResult.getFilter();
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = processor.getReturnedType();
        if (returnedType.isProjecting()) {
            return this.executeProjectingQuery(returnedType, queryResult, processor);
        }
        if (queryResult.getAggregator() != null) {
            return this.namedMap.aggregate(queryResult.getFilter(), queryResult.getAggregator());
        }
        if (partTree.isDelete()) {
            Map result2 = this.namedMap.invokeAll(Processors.remove((Filter)filter, (boolean)true));
            return result2.size();
        }
        Pageable pageable = accessor.getPageable();
        boolean pagingQuery = pageable != null && pageable.isPaged();
        LimitFilter limitFilter = null;
        InvocableMap.EntryAggregator aggregator = queryResult.getAggregator();
        if (pagingQuery) {
            limitFilter = Utils.configureLimitFilter(pageable, filter);
            if (limitFilter != null) {
                filter = limitFilter;
            } else {
                throw new IllegalStateException("LimitFilter should not have been null.");
            }
        }
        if (aggregator != null) {
            if (pagingQuery) {
                throw new IllegalStateException("Not possible to paginate aggregated results.");
            }
            return this.namedMap.aggregate(filter, aggregator);
        }
        Sort sort = queryResult.getSort();
        Collection collection = result = sort.isSorted() ? this.namedMap.values(filter, Utils.toComparator(sort)) : this.namedMap.values(filter);
        if (partTree.isExistsProjection()) {
            return !result.isEmpty();
        }
        if (pagingQuery) {
            if (this.queryMethod.isPageQuery()) {
                int count = (Integer)this.namedMap.aggregate(limitFilter.getFilter(), (InvocableMap.EntryAggregator)Aggregators.count());
                return new PageImpl(Arrays.asList(result.toArray()), pageable, (long)count);
            }
            if (this.queryMethod.isSliceQuery()) {
                return new SliceImpl(Arrays.asList(result.toArray()), pageable, result.size() == pageable.getPageSize());
            }
        }
        return result;
    }

    @Nullable
    private Object executeProjectingQuery(ReturnedType returnedType, QueryResult queryResult, ResultProcessor processor) {
        Class resultType = returnedType.getReturnedType();
        List result = resultType.isInterface() ? this.fetchWithInterfaceProjection(queryResult.getFilter(), resultType, returnedType.getDomainType()) : this.fetchWithClassProjection(queryResult.getFilter(), resultType);
        Sort sort = queryResult.getSort();
        Remote.Comparator comparator = Utils.toComparator(sort);
        Object processedResult = processor.processResult((Object)result);
        if (comparator != null && processedResult instanceof List) {
            ((List)processedResult).sort(comparator);
        }
        return processedResult;
    }

    private List fetchWithClassProjection(Filter filter, Class<?> resultType) {
        Constructor<?>[] constructors = resultType.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalArgumentException(String.format("Type %s has no public constructor.", resultType.getName()));
        }
        Constructor<?> constructor = constructors[0];
        String[] ctorParameterNames = (String[])Arrays.stream(constructor.getParameters()).map(Parameter::getName).toArray(String[]::new);
        ValueExtractor[] ctorArgsExtractors = (ValueExtractor[])Arrays.stream(ctorParameterNames).map(UniversalExtractor::new).toArray(ValueExtractor[]::new);
        InvocableMap.EntryProcessor entryProcessor = Processors.extract((ValueExtractor)Extractors.fragment((ValueExtractor[])ctorArgsExtractors));
        Collection values = this.namedMap.invokeAll(filter, entryProcessor).values();
        return values.stream().map(fragment -> this.createDto(constructor, ctorParameterNames, (Fragment)fragment)).collect(Collectors.toList());
    }

    private Object createDto(Constructor ctor, String[] argNames, Fragment fragment) {
        Object[] args = Arrays.stream(argNames).map(arg_0 -> ((Fragment)fragment).get(arg_0)).toArray();
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List fetchWithInterfaceProjection(Filter filter, Class<?> resultType, Class<?> domainType) {
        if (this.isOpenProjection(resultType)) {
            InvocableMap.EntryProcessor entryProcessor = Processors.extract((ValueExtractor)IdentityExtractor.INSTANCE);
            Collection values = this.namedMap.invokeAll(filter, entryProcessor).values();
            return new ArrayList(values);
        }
        InvocableMap.EntryProcessor entryProcessor = Processors.extract((ValueExtractor)Extractors.fragment((ValueExtractor[])this.createExtractors(resultType, domainType)));
        Collection values = this.namedMap.invokeAll(filter, entryProcessor).values();
        return values.stream().map(Fragment::toMap).collect(Collectors.toList());
    }

    private ValueExtractor[] createExtractors(Class<?> projection, Class<?> domainType) {
        Method[] methods;
        ArrayList<Object> extractors = new ArrayList<Object>();
        for (Method m : methods = projection.getMethods()) {
            Class<?> returnType = m.getReturnType();
            if (!returnType.isInterface() || this.isOpenProjection(returnType)) {
                extractors.add(new ReflectionExtractor(m.getName()));
                continue;
            }
            ReflectionExtractor from = new ReflectionExtractor(m.getName());
            Method domainMethod = ReflectionUtils.findMethod(domainType, (String)m.getName());
            if (domainMethod == null) {
                throw new IllegalArgumentException(String.format("Method '%s' not found in ", m.getName(), domainType));
            }
            if (returnType.isAssignableFrom(domainMethod.getReturnType())) {
                extractors.add(new ReflectionExtractor(m.getName()));
                continue;
            }
            ValueExtractor[] subExtractors = this.createExtractors(returnType, domainMethod.getReturnType());
            if (subExtractors.length <= 0) continue;
            extractors.add(Extractors.fragment((ValueExtractor)from, (ValueExtractor[])subExtractors));
        }
        return extractors.toArray(new ValueExtractor[0]);
    }

    private boolean isOpenProjection(Class<?> projection) {
        return Arrays.stream(projection.getMethods()).anyMatch(m -> m.isAnnotationPresent(Value.class));
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

